package com.yeejoin.precontrol.common.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.PersonMessage;
import com.yeejoin.precontrol.common.entity.Task;
import com.yeejoin.precontrol.common.entity.TaskPerson;
import com.yeejoin.precontrol.common.entity.TaskPersonFeedback;
import com.yeejoin.precontrol.common.enums.MessageTypeEnum;
import com.yeejoin.precontrol.common.enums.StatusEnum;
import com.yeejoin.precontrol.common.mapper.PersonMapper;
import com.yeejoin.precontrol.common.mapper.TaskPersonFeedbackMapper;
import com.yeejoin.precontrol.common.service.IPersonMessageService;
import com.yeejoin.precontrol.common.service.ITaskPersonFeedbackService;
import com.yeejoin.precontrol.common.service.ITaskPersonService;
import com.yeejoin.precontrol.common.service.ITaskService;
import com.yeejoin.precontrol.common.vo.PersonVo;

/**
 * 人员反馈表 服务实现类
 *
 * @author duanwei
 * @date 2020-12-08
 */
@Service
public class TaskPersonFeedbackServiceImpl extends ServiceImpl<TaskPersonFeedbackMapper, TaskPersonFeedback>
		implements ITaskPersonFeedbackService {

	@Autowired
	ITaskPersonService iTaskPersonService;

	@Autowired
	IPersonMessageService iPersonMessageService;

	@Autowired
	ITaskService iTaskService;

	@Autowired
	PersonMapper personMapper;

	@Override
	public boolean saveFeedBack(TaskPersonFeedback taskPersonFeedback) {
		this.save(taskPersonFeedback);
		TaskPerson taskPerson = new TaskPerson();
		taskPerson.setId(taskPersonFeedback.getTaskPersonId());
		taskPerson.setReadStatus(StatusEnum.FEEDBACK.getValue());
		iTaskPersonService.updateById(taskPerson);

		TaskPerson taskperson = iTaskPersonService.getById(taskPerson.getId());
		Task task = iTaskService.getById(taskperson.getTaskId());
		// 获取分包商主管
		List<Long> companyId = new ArrayList<>();
		companyId.add(taskperson.getCompanyId());
		List<PersonVo> list = personMapper.listByCompanyAndRole(companyId, "fbs_director");
		List<PersonMessage> messages = new ArrayList<>();
		for (PersonVo personVo : list) {
			PersonMessage message = new PersonMessage();
			message.setContent(MessageTypeEnum.SALARY.getName());
			message.setPersonId(personVo.getId());
			message.setProjectId(task.getProjectId());
			message.setObjectId(taskPerson.getId());
			message.setType(MessageTypeEnum.SALARY.getType());
			message.setSubType(taskPersonFeedback.getType().longValue());
			messages.add(message);
		}

		PersonMessage message = new PersonMessage();
		message.setContent(MessageTypeEnum.SALARY.getName());
		message.setPersonId(task.getCreatePersonId());
		message.setProjectId(task.getProjectId());
		message.setObjectId(taskPerson.getId());
		message.setType(MessageTypeEnum.SALARY.getType());
		message.setSubType(taskPersonFeedback.getType().longValue());
		messages.add(message);
		iPersonMessageService.saveBatch(messages);
		return true;
	}
}
