package com.yeejoin.amos.api.openapi.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@AllArgsConstructor
@Getter
public enum CylinderInspectionFieldEnum {
    sequenceCode(true, true),
    inspectionUnit(true, true),
    inspectionDate(true, true),
    inspectionResult(true, true),
    scrapQuantity(true, true),
    nextInspectionDate(true, true),
    syncDate(true, true),
    syncState(true, true);

    private boolean isRequire;
    private boolean isUnique;

    public static List<String> getAllRequireKeys() {
        List<String> keys = Arrays.stream(values()).filter(e -> e.isRequire).map(e -> e.name()).collect(Collectors.toList());
        return keys;
    }

    public  static List<String> getAllUniqueKeys() {
        List<String> keys = Arrays.stream(values()).filter(e -> e.isUnique).map(e -> e.name()).collect(Collectors.toList());
        return keys;
    }
}
