package com.yeejoin.amos.api.openapi.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@AllArgsConstructor
@Getter
public enum FillingAfterFieldEnum {
    sequenceCode(true, true),
    fillingCheckId(true, true),
    withinScope(true, false),
    sealedState(true, false),
    defective(true, false),
    abnormaLTemperature(true, false),
    warningSign(true, false),
    compliance(true, false),
    checkResults(true, false),
    nonconformances(true, false),
    inspector(true, false),
    inspectionDate(true, false),
    syncDate(true, false),
    syncState(true, false);

    private boolean isRequire;
    private boolean isUnique;

    public static List<String> getAllRequireKeys() {
        List<String> keys = Arrays.stream(values()).filter(e -> e.isRequire).map(e -> e.name()).collect(Collectors.toList());
        return keys;
    }

    public  static List<String> getAllUniqueKeys() {
        List<String> keys = Arrays.stream(values()).filter(e -> e.isUnique).map(e -> e.name()).collect(Collectors.toList());
        return keys;
    }
}
