package com.yeejoin.amos.api.openapi.enums;


import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@AllArgsConstructor
@Getter
public enum FillingBeforeFieldEnum {
    sequenceCode(true, true),
    fillingBeforeId(true, true),
    creditCode(true, false),
    fillingUnitName(true, false),
    inspectorUser(true, false),
    inspectionDate(true, false),
    isValid(true, false),
    same(true, false),
    isRegulations(true, false),
    isComplianceWithGBT(true, false),
    haveStillPressure(true, false),
    isComplete(true, false),
    haveSecurityDocuments(true, false),
    fillBeforeItem(true, false),
    checkResults(true, false),
    nonconformances(true, false),
    syncDate(true, false),
    syncState(true, false);

    private boolean isRequire;
    private boolean isUnique;

    public static List<String> getAllRequireKeys() {
        List<String> keys = Arrays.stream(values()).filter(e -> e.isRequire).map(e -> e.name()).collect(Collectors.toList());
        return keys;
    }

    public  static List<String> getAllUniqueKeys() {
        List<String> keys = Arrays.stream(values()).filter(e -> e.isUnique).map(e -> e.name()).collect(Collectors.toList());
        return keys;
    }
}
