package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import lombok.Data;
import lombok.EqualsAndHashCode;
/**
 * 气瓶充装信息--充装前检查
 * @author kinky
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_cylinder_filling")
public class TmCylinderFilling extends AbstractBaseEntity{/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	@TableField("credit_code")
	private String creditCode;
	@TableField("filling_unit_name")
	private String fillingUnitName;	//充装企业名称*
	@TableField("fill_before_item")
	private String fillBeforeItem;
	@TableField("sequence_code")
	private String sequenceCode;	//气瓶唯一标识码*
	@TableField("is_valid")
	private String isValid;	//是否在检验有效期以内，严禁充装超期未检气瓶、非法改装或翻新及报废气瓶
	@TableField("same")
	private int same;	//警示标签上印有的瓶装气体的名称及化学分子式应与气瓶钢印标志是否一致*
	@TableField("is_regulations")
	private int isRegulations;	//气瓶外表面的颜色标志是否符合规定*
	@TableField("is_compliance_withGBT")
	private int isComplianceWithGBT;	//气瓶瓶阀的出气口螺纹型式是否符合GB/T15383的规定，即可燃气体用的瓶阀，出口螺纹应是内螺纹（左旋）*
	@TableField("have_still_pressure")
	private int haveStillPressure;	//气瓶内有无剩余压力*
	@TableField("is_complete")
	private int isComplete;	//气瓶外表面有无裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷*
	@TableField("have_security_documents")
	private int haveSecurityDocuments;	//气瓶的安全附件齐全并符合安全要求
	@TableField("inspector_user")
	private String inspectorUser;	//检查人员姓名*
	@TableField("inspection_date")
	private String inspectionDate;	//检查时间*
	@TableField("nonconformances")
	private String nonconformances;
	@TableField("check_results")
	private String checkResults;
	/**
	 * 充装前检查id
	 */
	@TableField("filling_before_id")
	private String fillingBeforeId;



}
