package com.yeejoin.amos.api.openapi.face.service;


import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.yeejoin.amos.api.openapi.face.orm.dao.ESCylinderFillingRecordRepository;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.cylinder.api.entity.ESCylinderFillingRecordDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderFillingRecordDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderUnitDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderFillingRecord;
import com.yeejoin.amos.boot.module.cylinder.flc.api.mapper.CylinderFillingRecordMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderFillingRecordModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderFillingRecordMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderFillingRecord;


/**
 * 
 * <pre>
 * 液化气体气瓶充装信息-充装记录 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class TmCylinderFillingRecordService extends BaseService<TmCylinderFillingRecordModel, TmCylinderFillingRecord, TmCylinderFillingRecordMapper> {
    @Autowired
    private RedisTemplate redisTemplate;

	@Autowired
	CylinderFillingRecordMapper cylinderFillingRecordMapper;

	@Autowired
	ESCylinderFillingRecordRepository esCylinderFillingRecordRepository;
	@Autowired
	private SyncCylinderDataService syncCylinderDataService;

	@DSTransactional
	public String createCylinderFilling(List<TmCylinderFillingRecordModel> model) {
		// TODO Auto-generated method stub
//		if (ValidationUtil.isEmpty(model))
//			throw new BadRequest("气瓶标签信息为空.");
		syncCylinderFilling(model);

		for (TmCylinderFillingRecordModel cylinderFillingRecordModel : model) {
			cylinderFillingRecordModel.setRecDate(new Date());
			cylinderFillingRecordModel.setAppId(getAppId());
			this.createWithModel(cylinderFillingRecordModel);
		}
		return "OK";
	}

	@DS("tzs")
	private void syncCylinderFilling(List<TmCylinderFillingRecordModel> model) {
		syncCylinderDataService.syncCylinderFillingRecord(model);

		ArrayList<ESCylinderFillingRecordDto> models = Bean.toModels(model, ESCylinderFillingRecordDto.class);
		syncCylinderDataService.createCylinderFillingRecord(models);
	}

	private String getAppId() {
		String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
    	return bizTokenModel.getAppId();
	}

	public List<String> getDateList() {
    	return baseMapper.getDateList();
	}

}	
