package com.yeejoin.amos.api.openapi.face.service;


import java.util.Date;
import java.util.List;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderUnitModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderUnitMapper;
//import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderUnit;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderUnit;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderUnitDto;


/**
 * 
 * <pre>
 *  气瓶企业信息 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class TmCylinderUnitService extends BaseService<TmCylinderUnitModel, TmCylinderUnit, TmCylinderUnitMapper> {
    @Autowired
    private RedisTemplate redisTemplate;
	@Autowired
	private SyncCylinderDataService syncCylinderDataService;

	@DSTransactional
	public String createCylinderUnit(List<TmCylinderUnitModel> model) {
		if (ValidationUtil.isEmpty(model))
			throw new BadRequest("气瓶企业信息数据为空.");
		syncCylinderUnitModel(model);
		for (TmCylinderUnitModel cylinderUnitModel : model) {
			cylinderUnitModel.setRecDate(new Date());
			cylinderUnitModel.setAppId(getAppId());
			this.createWithModel(cylinderUnitModel);
		}
		return "OK";
	}
	private void syncCylinderUnitModel(List<TmCylinderUnitModel> model ) {
		  syncCylinderDataService.syncCylinderUnit(model);
	}
	private String getAppId() {
		String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
    	return bizTokenModel.getAppId();
	}
	
}
