package com.yeejoin.amos.boot.module.jg.biz.config;

import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.yeejoin.amos.boot.biz.config.MetaHandler;
import com.yeejoin.amos.boot.biz.config.MybatisSqlInjector;
import com.zaxxer.hikari.HikariDataSource;
import io.seata.rm.datasource.DataSourceProxy;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

/**
 * 数据源代理
 *
 * @author LiuLin
 */
@Configuration
public class DataSourceConfiguration {

    @Autowired
    private DataSourceProperties dsp;

    @Bean(name = "hikariDataSource")
    public HikariDataSource hikariDataSource() {
        HikariDataSource hds = new HikariDataSource();
        hds.setSchema(dsp.getSchema().get(0));
        hds.setUsername(dsp.getUsername());
        hds.setPassword(dsp.getPassword());
        hds.setJdbcUrl(dsp.getUrl());
        hds.setDriverClassName(dsp.getDriverClassName());
        hds.setConnectionTimeout(3000);
        hds.setMaximumPoolSize(30);
        hds.setMinimumIdle(10);
        return hds;
    }

    @Primary
    @Bean("dataSource")
    public DataSourceProxy dataSourceProxy(DataSource hikariDataSource) {
        return new DataSourceProxy(hikariDataSource);
    }

    @Bean(name = "sqlSessionFactory")
    @Autowired
    public SqlSessionFactory sqlSessionFactoryBean(DataSource dataSourceProxy, PaginationInterceptor paginationInterceptor, MetaHandler metaHandler) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSourceProxy);
        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        bean.setMapperLocations(resolver.getResources("classpath*:mapper/*.xml"));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setSqlInjector(new MybatisSqlInjector());
        globalConfig.setMetaObjectHandler(metaHandler);
        bean.setGlobalConfig(globalConfig);
        Interceptor[] plugins = {paginationInterceptor};
        bean.setPlugins(plugins);
        return bean.getObject();
    }

    @Bean
    public MetaHandler metaHandler() {
        return new MetaHandler();
    }
}
