package com.yeejoin.amos.boot.module.jyjc.api.mapper;

import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseUnitLicenceDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzsUserInfoDto;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *  Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-13
 */
@Mapper
public interface JyjcBaseMapper {

    List<TzBaseUnitLicenceDto> selectBaseUnitLicenceList(Map<String, Object> params);

    @MapKey(value = "code")
    List<Map<String, String>> selectDataDictionaryList(List<String> codes);

    String selectBusinessData(String tableName, String instanceId,String key);

    void updateBusinessData(String tableName, String assignee, String transferToUserIds, String instanceId, String nextTaskId, String key);


    void updateBusinessDataWithCompany(String tableName, String assignee, String transferToUserIds, String instanceId, String nextTaskId, String key, String inspectionUnitCode, String companyName);

    List<TzsUserInfoDto> selectParentOrgUsers(@Param("parentOrgCodeList") Set<String> parentOrgCodeList);

    /**
     * 按照公司编码查询公司下的人
     * @param companyCodes
     * @return  List<TzsUserInfoDto>
     */
    List<TzsUserInfoDto> selectUserByCompanyCodes(@Param("companyCodes") List<String> companyCodes);

    CompanyModel selectOneCompanyByCode(String companyCode);
}
