package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.biz.common.workflow.feign.WorkflowFeignService;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.jyjc.api.entity.*;
import com.yeejoin.amos.boot.module.jyjc.api.enums.*;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcBaseMapper;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationEquipMapper;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.*;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionApplicationService;
import com.yeejoin.amos.boot.module.jyjc.biz.event.InspectionApplicationPushEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.event.publisher.EventPublisher;
import com.yeejoin.amos.boot.module.jyjc.biz.feign.JgFeignClient;
import com.yeejoin.amos.boot.module.jyjc.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jyjc.biz.service.TaskModelServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquimentEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgUseInfoMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.io.IOException;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;


/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
@Slf4j
public class JyjcInspectionApplicationServiceImpl extends BaseService<JyjcInspectionApplicationModel, JyjcInspectionApplication, JyjcInspectionApplicationMapper> implements IJyjcInspectionApplicationService {

    @Autowired
    private JyjcInspectionResultServiceImpl inspectionResultService;
    @Autowired
    private JyjcInspectionApplicationEquipServiceImpl applicationEquipService;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;

    @Autowired
    EventPublisher eventPublisher;

    @Autowired
    @Lazy
    InspectionPlanServiceImpl inspectionPlanService;
    /**
     * 分页查询
     */

    @Autowired
    JyjcInspectionApplicationAttachmentServiceImpl jyjcInspectionApplicationAttachmentService;

    @Autowired
    JyjcInspectionApplicationEquipServiceImpl jyjcInspectionApplicationEquipService;

    @Autowired
    JyjcInspectionApplicationPushLogServiceImpl jyjcInspectionApplicationPushLogService;

    @Autowired
    JyjcOpeningApplicationServiceImpl jyjcOpeningApplicationService;

    @Autowired
    WorkflowFeignService workflowFeignService;

    @Autowired
    CommonServiceImpl commonService;

    @Autowired
    CmWorkflowServiceImpl cmWorkflowService;

    @Value("classpath:/json/bizTypeInfo.json")
    private Resource bizTypeInfo;

    @Autowired
    private JyjcInspectionApplicationEquipMapper jyjcInspectionApplicationEquipMapper;

    @Autowired
    JgFeignClient jgFeignClient;

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    TaskModelServiceImpl taskModelService;

    @Autowired
    DataDictionaryServiceImpl dataDictionaryService;

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;

    @Autowired
    JyjcOpeningApplicationServiceImpl openingApplicationService;

    @Autowired
    RedissonClient redissonClient;

    @Autowired
    JyjcBaseMapper jyjcBaseMapper;

    @Autowired
    IdxBizJgUseInfoMapper jgUseInfoMapper;

    private static final String EQU_STATE = "EQU_STATE";

    private static final String EQU_CODE = "EQU_CODE";

    private static final String SEQUENCE_NBR = "SEQUENCE_NBR";

    private static final String SUMMIT_TYPE = "0";


    @Autowired
    RestHighLevelClient restHighLevelClient;

    @Transactional(rollbackFor = Exception.class)
    public JyjcInspectionApplicationModel save(@RequestBody JSONObject obj, ReginParams reginParams) {
        //接口通用 部分页面按钮无法分开配置类型 所以根据业务情况 将带有工作流实例id的数据 接口类型设置为2 走编辑逻辑
        JyjcInspectionApplicationModel model = JSONObject.parseObject(JSON.toJSONString(obj), JyjcInspectionApplicationModel.class);
        model.setEquip((List<Map<String, Object>>) obj.get("equip"));
        // 校验流程中的不能再次提交
        this.checkForFlowingEquip(model);
        if (CharSequenceUtil.isNotEmpty(model.getProcessInstanceId()) && model.getOperationType().equals("0")) {
            model.setOperationType("2");
        }

        ArrayList<String> roleListAll = new ArrayList<>();
        ArrayList<String> roleListNext = new ArrayList<>();
        if (!"2".equals(model.getOperationType())) {
            String taskName = "";
            if ("0".equals(model.getOperationType())) {  // 工作台提交逻辑、详情页面保存并提交逻辑
                List<ProcessTaskDTO> processTasks = new ArrayList<>();
                ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                List<ActWorkflowStartDTO> list = new ArrayList<>();
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(model.getProcessKey());
                dto.setBusinessKey(String.valueOf(new Date().getTime()));
                dto.setCompleteFirstTask(true);
                list.add(dto);
                actWorkflowBatchDTO.setProcess(list);
                String[] inspectionUnit = model.getInspectionUnitCode().split("_");
                if (inspectionUnit.length == 2) {
                    model.setInspectionUnitCode(inspectionUnit[0]);
                    model.setInspectionUnitName(inspectionUnit[1]);
                } else {
                    this.setInspectionUnitNameAfterSave(model);
                }
                dto.setNextExecuteUserCompanyCode(model.getInspectionUnitCode());
                processTasks = cmWorkflowService.startBatch(actWorkflowBatchDTO);
                String instanceId = processTasks.get(0).getProcessInstance().getId();
                String nextTaskId = processTasks.get(0).getNextTask().get(0).getId();
                taskName = processTasks.get(0).getNextTask().get(0).getName();
                this.buildRoleList(processTasks, roleListNext, roleListAll);
                List<WorkflowResultDto> workflowResultDtos = taskModelService.buildWorkFlowInfo(processTasks);
                String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
                String nextExcuteIds = workflowResultDtos.get(0).getNextExecutorRoleIds();
                model.setProcessInstanceId(instanceId);
                model.setInstanceId(instanceId);
                if (!org.springframework.util.ObjectUtils.isEmpty(model.getWorkflowRole())) {
                    model.setWorkflowRole(model.getWorkflowRole() + "," + nextExcuteIds);
                } else {
                    model.setWorkflowRole(nextExcuteIds);
                }
                model.setNextExecuteIds(nextExcuteIds);
                model.setNextTaskId(nextTaskId);
                model.setNextTaskName(taskName);
                model.setPromoter(RequestContext.getExeUserId());
                model.setNextExecuteUserIds(nextUserIds);
                model.setStatus(String.valueOf(FlowStatusEnum.TO_SUBMITTED.getCode())); //6611 对应数据字典 检验流程状态 待受理
                commonService.saveExecuteFlowData2Redis(model.getProcessInstanceId(), this.buildInstanceRuntimeData(model));
            } else if ("1".equals(model.getOperationType())) {  //  工作台暂存、详情保存逻辑
                String[] inspectionUnit = model.getInspectionUnitCode().split("_");
                if (inspectionUnit.length == 2) {
                    model.setInspectionUnitCode(inspectionUnit[0]);
                    model.setInspectionUnitName(inspectionUnit[1]);
                } else {
                    this.setInspectionUnitNameAfterSave(model);
                }
                model.setStatus(String.valueOf(FlowStatusEnum.TO_BE_SUBMITTED.getCode()));
            }

            LambdaQueryWrapper<JyjcOpeningApplication> wa = new LambdaQueryWrapper<JyjcOpeningApplication>().eq(JyjcOpeningApplication::getUnitCode, model.getInspectionUnitCode()).eq(JyjcOpeningApplication::getStatus, FlowStatusEnum.TO_BE_FINISHED.getCode());
            List<JyjcOpeningApplication> jyjcOpeningApplications = jyjcOpeningApplicationService.getBaseMapper().selectList(wa);
            if (CollectionUtils.isNotEmpty(jyjcOpeningApplications)) {
                //检验检测结果方式
                if (jyjcOpeningApplications.get(0).getResultType() != null) {
                    model.setResultType(jyjcOpeningApplications.get(0).getResultType());
                    // 报检时冗余检验检测机构厂商编号，推送厂商报检信息时需要
                    model.setDockingUnitCode(jyjcOpeningApplications.get(0).getDockingUnitCode());
                }
            }

            model.setApplicationDate(new Date());
            model.setPromoter(reginParams.getUserModel().getUserId());
            model.setApplicationUnitName(reginParams.getCompany().getCompanyName());

            jyjcInspectionApplicationEquipService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
            List<JyjcInspectionApplicationEquip> equipInfos = new ArrayList<>();
            if (null != model.getEquip() && model.getEquip().size() > 0) {
                List<JyjcInspectionApplicationEquipDto> equips = JSONObject.parseArray(JSON.toJSONString(model.getEquip()), JyjcInspectionApplicationEquipDto.class);
                for (JyjcInspectionApplicationEquipDto equip : equips) {
                    JyjcInspectionApplicationEquip equipInfo = new JyjcInspectionApplicationEquip();
                    equipInfo.setEquDefine(equip.getEquDefineCode());
                    equipInfo.setEquList(equip.getEquListCode());
                    equipInfo.setEquipUnicode(equip.getSequenceNbr());
                    equipInfo.setEquCategory(equip.getEquCategoryCode());
                    equipInfo.setSupervisoryCode(equip.getSupervisoryCode());
                    equipInfos.add(equipInfo);
                }
                model.setEquList(model.getEquip().get(0).getOrDefault("EQU_LIST", "").toString());
                model.setSupervisoryCode(model.getEquip().get(0).getOrDefault("SUPERVISORY_CODE", "").toString());
            }
            model.setCreateUserId(reginParams.getUserModel().getUserId());
            model.setNumberOfEquip(equipInfos.size());
            if (null == model.getSequenceNbr()) {
                List<String> codes = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.JY.getCode(), 1).getResult();
                model.setApplicationNo(codes.get(0));
                model = this.createWithModel(model);
                if (StringUtils.isNotBlank(model.getProcessInstanceId())) {
                    this.createdTaskModel(model);
                } else {
                    TaskModelDto dto = new TaskModelDto();
                    TaskMessageDto ta = new TaskMessageDto();
                    ta.setInstanceId(model.getProcessInstanceId());
                    ta.setStatus(model.getStatus());
                    ta.setPromoter(model.getPromoter());
                    ta.setNextExecuteUserIds(model.getNextExecuteUserIds());
                    ta.setSequenceNbr(model.getSequenceNbr());
                    ta.setProcessInstanceId(model.getProcessInstanceId());
                    ta.setProcessKey(model.getProcessKey());
                    ta.setCreateUserId(RequestContext.getExeUserId());
                    ta.setNextTaskId(model.getNextTaskId());
                    dto.setModel(ta);
                    //摘要 按原有规则组装
                    dto.setTaskContent("来自" + model.getEquList() + "【" + model.getSupervisoryCode() + "】的业务办理,【申请单号:" + model.getApplicationNo() + "】");
                    //申请单号
                    dto.setTaskCode(model.getApplicationNo());
                    //业务类型枚举code值
                    dto.setTaskType(BizTypeEnum.getNumByCode(model.getBizType()));
                    ////业务主键
                    dto.setRelationId(model.getSequenceNbr() + "");
                    taskModelService.buildTaskModel(Arrays.asList(dto));
                }
            } else {
                model = this.updateWithModel(model);

                if (StringUtils.isNotBlank(model.getProcessInstanceId()) && model.getOperationType().equals("0")) {
                    taskModelService.deleteTaskModel(model.getSequenceNbr() + "");
                    this.createdTaskModel(model);
                } else {

                    String taskContent = "来自" + model.getEquList() + "【" + model.getSupervisoryCode() + "】的业务办理,【申请单号:" + model.getApplicationNo() + "】";
                    taskModelService.updateTaskContentById(MapBuilder.<String, Object>create().put("taskContent", taskContent).
                            put("relationId", model.getSequenceNbr() + "").build());
                }
            }


            //保存报检装备监管码
            for (JyjcInspectionApplicationEquip equipInfo : equipInfos) {
                equipInfo.setApplicationSeq(model.getSequenceNbr());
            }
            applicationEquipService.saveBatch(equipInfos);
            // 附件保存
            List<String> enumNameList = DocumentEnum.getEnumNameList();
            for (String code : enumNameList) {
                if (obj.containsKey(code)) {
                    JyjcInspectionApplicationAttachment attachments = new JyjcInspectionApplicationAttachment();
                    attachments.setAttachmentType(code);
                    attachments.setAttachmentUrl(JSONObject.toJSONString(obj.get(code)));
                    attachments.setApplicationSeq(model.getSequenceNbr());
                    jyjcInspectionApplicationAttachmentService.getBaseMapper().insert(attachments);
                }
            }
        } else {
            // 保存并提交
            LambdaQueryWrapper<JyjcOpeningApplication> wa = new LambdaQueryWrapper<JyjcOpeningApplication>().eq(JyjcOpeningApplication::getUnitCode, model.getInspectionUnitCode()).eq(JyjcOpeningApplication::getStatus, FlowStatusEnum.TO_BE_FINISHED.getCode());
            List<JyjcOpeningApplication> jyjcOpeningApplications = jyjcOpeningApplicationService.getBaseMapper().selectList(wa);
            if (CollectionUtils.isNotEmpty(jyjcOpeningApplications)) {
                //检验检测结果方式
                if (jyjcOpeningApplications.get(0).getResultType() != null) {
                    model.setResultType(jyjcOpeningApplications.get(0).getResultType());
                    // 报检时冗余检验检测机构厂商编号，推送厂商报检信息时需要
                    model.setDockingUnitCode(jyjcOpeningApplications.get(0).getDockingUnitCode());
                }
            }
            this.setInspectionUnitNameAfterSave(model);

            //更新报检装备监管码
            jyjcInspectionApplicationEquipService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
            if (model.getEquip().size() > 0) {
                List<JyjcInspectionApplicationEquipDto> equips = JSONObject.parseArray(JSON.toJSONString(model.getEquip()), JyjcInspectionApplicationEquipDto.class);
                int num = equips.size();
                model.setNumberOfEquip(num);
                for (JyjcInspectionApplicationEquipDto equip : equips) {
                    JyjcInspectionApplicationEquip equipInfo = new JyjcInspectionApplicationEquip();
                    equipInfo.setEquDefine(equip.getEquDefineCode());
                    equipInfo.setEquList(equip.getEquListCode());
                    equipInfo.setEquipUnicode(equip.getSequenceNbr());
                    equipInfo.setEquCategory(equip.getEquCategoryCode());
                    equipInfo.setApplicationSeq(model.getSequenceNbr());
                    jyjcInspectionApplicationEquipService.save(equipInfo);
                }
                model.setEquList(model.getEquip().get(0).getOrDefault("EQU_LIST", "").toString());
                model.setSupervisoryCode(model.getEquip().get(0).getOrDefault("SUPERVISORY_CODE", "").toString());
            }

            // 附件更新
            List<String> enumNameList = DocumentEnum.getEnumNameList();

            jyjcInspectionApplicationAttachmentService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
            for (String code : enumNameList) {
                if (obj.containsKey(code)) {
                    JyjcInspectionApplicationAttachment attachments = new JyjcInspectionApplicationAttachment();
                    attachments.setAttachmentType(code);
                    attachments.setAttachmentUrl(JSONObject.toJSONString(obj.get(code)));
                    attachments.setApplicationSeq(model.getSequenceNbr());
                    jyjcInspectionApplicationAttachmentService.getBaseMapper().insert(attachments);
                }
            }
            //6611 对应数据字典 检验流程状态 待受理
            model.setStatus(String.valueOf(FlowStatusEnum.TO_SUBMITTED.getCode()));

            ArrayList<String> roleList = new ArrayList<>();
            String taskId = model.getNextTaskId();
            //组装信息
            TaskResultDTO task = new TaskResultDTO();
            task.setResultCode("approvalStatus");
            task.setTaskId(taskId);
            task.setComment("");
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", "提交");
            task.setVariable(map);
            //执行流程
            task.setNextExecuteUserCompanyCode(model.getInspectionUnitCode());
            ProcessTaskDTO processTaskDTO = cmWorkflowService.complete(taskId, task);
            String taskName1 = "";
            String nextTaskId = "";
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleList, roleListAll);
            List<WorkflowResultDto> workflowResultDtos = taskModelService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
            String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
            String executorRoleIds = workflowResultDtos.get(0).getExecutorRoleIds();
            if (processTaskDTO != null && processTaskDTO.getNextTask() != null && processTaskDTO.getNextTask().size() > 0) {
                taskName1 = processTaskDTO.getNextTask().get(0).getName();
                nextTaskId = processTaskDTO.getNextTask().get(0).getId();
            }
            model.setNextExecuteIds(String.join(",", roleList));
            if (!org.springframework.util.ObjectUtils.isEmpty(model.getWorkflowRole())) {
                model.setWorkflowRole(model.getWorkflowRole() + "," + String.join(",", roleList));
            } else {
                model.setWorkflowRole(String.join(",", roleList));
            }
            model.setNextTaskId(nextTaskId);
            model.setPromoter(RequestContext.getExeUserId());
            model.setStatus(String.valueOf(FlowStatusEnum.TO_SUBMITTED.getCode()));
            model.setStatusName(FlowStatusEnum.TO_SUBMITTED.getName());
            model.setNextTaskName(taskName1);
            model.setNextExecuteIds(executorRoleIds);
            model.setNextExecuteUserIds(nextUserIds);
            createNextTask(model, taskName1, nextUserIds);
            commonService.saveExecuteFlowData2Redis(model.getProcessInstanceId(), this.buildInstanceRuntimeData(model));
            this.updateWithModel(model);
        }
        return this.buildRedundancyField(model);
    }

    /**
     * 提交时校验是否有在流程中（流程状态待受理）的设备
     *
     * @param model 提交对象
     */
    private void checkForFlowingEquip(JyjcInspectionApplicationModel model) {
        String operationType = model.getOperationType();
        List<String> recordsInFlowing = new ArrayList<>();
        if (SUMMIT_TYPE.equals(operationType)) {
            List<JyjcInspectionApplicationEquipDto> equips = JSONObject.parseArray(JSON.toJSONString(model.getEquip()), JyjcInspectionApplicationEquipDto.class);
            recordsInFlowing = this.getBaseMapper().queryRecordListInFlowing(equips);
        }
        if (recordsInFlowing.size() > 0) {
            throw new BadRequest("存在设备已经在流程中，不允许重复提交检验！");
        }
    }

    private void setInspectionUnitNameAfterSave(JyjcInspectionApplicationModel model) {
        CompanyModel companyModel = jyjcBaseMapper.selectOneCompanyByCode(model.getInspectionUnitCode());
        if (companyModel != null) {
            model.setInspectionUnitName(companyModel.getCompanyName());
        }
    }

    private JyjcInspectionApplicationModel buildRedundancyField(JyjcInspectionApplicationModel model) {
        // 冗余前端显示检验检测类型名称
        if (StringUtils.isNotEmpty(model.getInspectionType())) {
            model.setInspectionTypeName(getInspectionTypeName(model.getInspectionType()));
        }
        return model;
    }

    private String getInspectionTypeName(String inspectionType) {
        DataDictionary dictionary = dataDictionaryService.getByCode(inspectionType, "JYJC");
        return dictionary != null ? dictionary.getName() : "";
    }


    @Override
    public Boolean deleteBatchData(List<Long> sequenceNbr) {
        this.deleteBatchSeq(sequenceNbr);
        for (Long seq : sequenceNbr) {
            jyjcInspectionApplicationEquipService.getBaseMapper().deleteByApplicationSeq(seq);
            jyjcInspectionApplicationAttachmentService.getBaseMapper().deleteByApplicationSeq(seq);
            jyjcInspectionApplicationPushLogService.getBaseMapper().deleteByApplicationSeq(seq);
        }
        return true;

    }

    public Page<JyjcInspectionApplicationEquipModel> listByCategory(Page<JyjcInspectionApplicationEquipModel> page, String equipClassify) {
        return getBaseMapper().listByCategory(page, equipClassify);
    }


    public Page<JyjcInspectionApplicationModel> queryForJyjcInspectionApplicationPage(Page<JyjcInspectionApplication> page,
                                                                                      String applicationNo,
                                                                                      String inspectionClassify,
                                                                                      String applicationUnitCode,
                                                                                      String equipClassify,
                                                                                      String inspectionUnitCode,
                                                                                      String applicationUnitName,
                                                                                      String inspectionUnitName,
                                                                                      String applicationDate,
                                                                                      String acceptDate,
                                                                                      String inspectionChargePerson,
                                                                                      String status, String bizType) {

        return this.getBaseMapper().queryForDataList(page, applicationNo, inspectionClassify, applicationUnitCode, applicationUnitName, equipClassify, inspectionUnitCode, inspectionUnitName, applicationDate, acceptDate, inspectionChargePerson, status, bizType);

    }

    @Override
    public Page<JyjcInspectionApplicationModel> queryForPageList(Page<JyjcInspectionApplication> page, JyjcInspectionApplicationModel model) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(),
                RequestContext.getToken())).toString(), ReginParams.class);
        String companyType = reginParams.getCompany().getCompanyType();
        String companyCode = reginParams.getCompany().getCompanyCode();
        String currentUserId = reginParams.getUserModel().getUserId();
        String currentApplicationUnitCode = null;
        String currentInspectionUnitCode = null;
        if (ValidationUtil.isEmpty(companyType)) {
            return new Page<>(0, 10, 0);
        }
        // 判断当前登录人身份（报检机构、接收机构、即时报检又是接收机构、都不是（不存在此情况））
        String identity = this.getCompanyIdentityByType(reginParams.getCompany().getCompanyType());
        if (ValidationUtil.equals("apply", identity)) {
            currentApplicationUnitCode = companyCode;
        }
        if (ValidationUtil.equals("receive", identity)) {
            currentInspectionUnitCode = companyCode;
        }
        if (ValidationUtil.equals("all", identity)) {
            currentApplicationUnitCode = companyCode;
            currentInspectionUnitCode = companyCode;
        }
        return this.getBaseMapper().selectForPage(page, model, identity, currentApplicationUnitCode, currentInspectionUnitCode, currentUserId);
    }

    private String getCompanyIdentityByType(String companyType) {
        // 可发起单位的单位类型（角色与单位类型已绑定，在业务系统增加的账号不会出现角色与的单位类型不匹配场景）
        String[] applyIdentityDefine = {"使用单位", "安装改造维修单位"};
        // 可进行检验检测申请接收的单位类型，在业务系统增加的账号不会出现角色与的单位类型不匹配场景
        String[] receiveIdentityDefine = {"检验检测机构"};
        boolean isApplyIdentityMatch = false;
        boolean isReceiveIdentityMatch = false;
        if (Arrays.stream(applyIdentityDefine).anyMatch(companyType::contains)) {
            isApplyIdentityMatch = true;
        }
        if (Arrays.stream(receiveIdentityDefine).anyMatch(companyType::contains)) {
            isReceiveIdentityMatch = true;
        }
        if (isApplyIdentityMatch && !isReceiveIdentityMatch) {
            return "apply";
        }
        if (!isApplyIdentityMatch && isReceiveIdentityMatch) {
            return "receive";
        }
        if (isApplyIdentityMatch) {
            return "all";
        }
        return "no";
    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionApplicationModel> queryForJyjcInspectionApplicationList() {
        return this.queryForList("", false);
    }

    public Map<String, Object> selectBySeq(Long sequenceNbr) {
        JyjcInspectionApplicationModel model = this.getBaseMapper().selectDataBySeq(sequenceNbr);
        Map<String, Object> map = BeanUtil.beanToMap(model);
        List<Map<String, Object>> dataByApplicationSeq = jyjcInspectionApplicationAttachmentService.getBaseMapper().getDataByApplicationSeq(sequenceNbr);
        Map<String, Object> attMap = new HashMap<>();
        for (Map<String, Object> maps : dataByApplicationSeq) {
            List<AttachmentDto> data = JSONArray.parseArray(maps.get("attachment_url").toString(), AttachmentDto.class);
            attMap.put(maps.get("attachment_type").toString(), data);
        }
        LambdaQueryWrapper<JyjcInspectionApplicationEquip> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(JyjcInspectionApplicationEquip::getApplicationSeq, sequenceNbr);
        List<JyjcInspectionApplicationEquip> jyjcInspectionApplicationEquips = jyjcInspectionApplicationEquipMapper.selectList(wrapper);
        String collect = jyjcInspectionApplicationEquips.stream().map(JyjcInspectionApplicationEquip::getEquipUnicode).distinct().collect(Collectors.joining(","));
        HashMap<String, Object> hashMap = new HashMap<>();
        hashMap.put("number", 1);
        hashMap.put("size", jyjcInspectionApplicationEquips.size());
        hashMap.put("SEQUENCE_NBR", collect);
        FeignClientResult<Page<JSONObject>> response = jgFeignClient.queryForPage(hashMap);
        if (200 == response.getStatus() && ObjectUtils.isNotEmpty(response.getResult())) {
            List<JSONObject> records = response.getResult().getRecords();
            ArrayList<Map<String, Object>> arrayList = new ArrayList<>();
            records.forEach(item -> {
                HashMap<String, Object> objectHashMap = new HashMap<>();
                for (Map.Entry<String, Object> stringObjectEntry : item.entrySet()) {
                    objectHashMap.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                    String s = stringObjectEntry.getKey().toLowerCase();
                    objectHashMap.put(CharSequenceUtil.toCamelCase(s), stringObjectEntry.getValue());
                    if (stringObjectEntry.getKey().equals("SEQUENCE_NBR")) {
                        objectHashMap.put("record", stringObjectEntry.getValue());
                    }
                }
                arrayList.add(objectHashMap);
            });
            map.put("equip", arrayList);
        }
        map.putAll(attMap);
        this.setPlanData(sequenceNbr, map);
        return map;
    }

    private void setPlanData(Long sequenceNbr, Map<String, Object> map) {
        JSONObject planData = inspectionPlanService.getDetail(String.valueOf(sequenceNbr));
        map.put("planData", planData);
    }

    /**
     * 接收
     *
     * @param params params
     * @return {@link }
     * @throws
     * @author yangyang
     * @date 2023/12/15 15:14
     */
    @Transactional(rollbackFor = Exception.class)
    public void doReceive(Map<String, Object> params) {
        String instanceId = params.get("instanceId").toString();
        String nextTaskId = params.get("nextTaskId").toString();
        String lockKey = CommonServiceImpl.buildJcExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForExecuteFlow(nextTaskId, instanceId);
            Long sequenceNbr = Long.parseLong(params.get("sequenceNbr") + "");
            JyjcInspectionApplication entity = this.getBaseMapper().selectById(sequenceNbr);
            //组装信息
            TaskResultDTO task = new TaskResultDTO();
            task.setResultCode("approvalStatus");
            task.setTaskId(nextTaskId);
            task.setComment(params.getOrDefault("comments", "").toString());
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", "0");
            task.setVariable(map);
            //执行流程
            task.setNextExecuteUserCompanyCode(entity.getInspectionUnitCode());
            cmWorkflowService.complete(nextTaskId, task);
            entity.setStatus(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()));
            JyjcInspectionApplicationModel model = new JyjcInspectionApplicationModel();
            model.setStatusName(FlowStatusEnum.TO_BE_FINISHED.getName());
            entity.setAcceptDate(new Date());
            entity.setInnerPersonCode(params.getOrDefault("innerPersonCode", "").toString());
            String processDescription = (String) params.get("comments");
            if (StringUtils.isNotBlank(processDescription)) {
                entity.setProcessDescription(processDescription);
            }
            entity.setNextExecuteUserIds("");
            entity.setPromoter("");
            entity.setNextExecuteIds("");
            entity.setNextTaskId("");
            this.updateById(entity);
            BeanUtils.copyProperties(entity, model);
            TaskV2Model taskV2Model = updateTaskModel(model);
            List<JyjcInspectionApplicationEquipModel> applicationEquipModels = applicationEquipService.listApplicationEquipByApplicationSeq(sequenceNbr);
            List<JyjcInspectionResult> resultModels = new ArrayList<>();
            List<String> codes = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.JG.getCode(), applicationEquipModels.size()).getResult();
            List<JgResumeInfoDto> jgResumeInfoDtoList = new ArrayList<>();
            for (int i = 0; i < applicationEquipModels.size(); i++) {
                JyjcInspectionResult resultModel = new JyjcInspectionResult();
                resultModel.setInspectionUnitCode(model.getInspectionUnitCode());
                resultModel.setInspectionUnitName(model.getInspectionUnitName());
                resultModel.setApplicationNo(model.getApplicationNo());
                resultModel.setApplicationUnitCode(model.getApplicationUnitCode());
                resultModel.setApplicationUnitName(model.getApplicationUnitName());
                resultModel.setResultStatus(ResultStatusEnum.NO_RESULT.getCode());
                resultModel.setApplicationDate(model.getApplicationDate());

                resultModel.setInspectionType(model.getInspectionType());
                resultModel.setInspectionTypeName(this.getDictNameByCode(model.getInspectionType()));
                // 解析设备
                resultModel.setBizType(model.getBizType());
                resultModel.setResultNo(codes.get(i));
                //设备唯一标识
                resultModel.setEquipUnicode(applicationEquipModels.get(i).getEquipUnicode());
                resultModel.setSupervisoryCode(applicationEquipModels.get(i).getSupervisoryCode());
                resultModel.setEquDefine(applicationEquipModels.get(i).getEquDefine());
                resultModel.setEquCategory(applicationEquipModels.get(i).getEquCategory());
                resultModel.setEquList(applicationEquipModels.get(i).getEquList());
                resultModel.setIsExistNc(false);
                this.setResultTypeByBizType(resultModel, model.getBizType());
                resultModels.add(resultModel);
                // 新增设备履历信息
                jgResumeInfoDtoList.add(JgResumeInfoDto.builder()
                        .applyNo(entity.getApplicationNo())
                        .businessType(resultModel.getInspectionTypeName())
                        .businessId(String.valueOf(entity.getSequenceNbr()))
                        .equId(applicationEquipModels.get(i).getEquipUnicode())
                        .approvalUnit(model.getInspectionUnitName())
                        .approvalUnitCode(model.getInspectionUnitCode())
                        .status("正常")
                        .routePath(taskV2Model.getRoutePath())
                        .build());
            }
            inspectionResultService.saveOrUpdateBatch(resultModels);
            // 报检信息推送
            this.pushInspectionApplication(model);
            this.saveBatchResume(jgResumeInfoDtoList);
            // 更新流程中的流程数据
            commonService.saveExecuteFlowData2Redis(model.getProcessInstanceId(), this.buildInstanceRuntimeData(entity));
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }


    private void saveBatchResume(List<JgResumeInfoDto> jgResumeInfoDtoList) {
        try {
            jgFeignClient.saveBatchResume(jgResumeInfoDtoList);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setResultTypeByBizType(JyjcInspectionResult resultModel, String bizType) {
        // 由于一个检验检测单位可以申请开通检验、检测两个申请，即确定一个 开通申请的维度为：单位编码 + 开通业务类型
        // 但是表里面放的使用单位的公司编码，导致无法匹配到正确的开通申请,故按照单位编码+ 开通类型 + 状态查询开通申请
        BizTypeEnum bizTypeEnum = BizTypeEnum.getInstance(bizType);
        String openBizType = "";
        assert bizTypeEnum != null;
        switch (bizTypeEnum) {
            case SUPERVISE:
            case FIRST_INSPECTION:
                openBizType = OpenBizTypeEnum.JY.getCode();
                break;
            case DETECTION:
                openBizType = OpenBizTypeEnum.JC.getCode();
                break;
            default:
                break;
        }
        LambdaQueryWrapper<JyjcOpeningApplication> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(JyjcOpeningApplication::getUnitCode, resultModel.getInspectionUnitCode());
        queryWrapper.eq(JyjcOpeningApplication::getOpenBizType, openBizType);
        queryWrapper.eq(JyjcOpeningApplication::getStatus, FlowStatusEnum.TO_BE_FINISHED.getCode());
        queryWrapper.select(JyjcOpeningApplication::getResultType);
        List<JyjcOpeningApplication> applicationList = jyjcOpeningApplicationService.list(queryWrapper);
        if (applicationList.size() > 0) {
            resultModel.setResultType(applicationList.get(0).getResultType());
        }
    }

    private void pushInspectionApplication(JyjcInspectionApplicationModel inspectionApplicationModel) {
        // 将检验检测申请信息推送至对应的检验机构
        if (inspectionApplicationModel.getResultType().equals(ResultTypeEnum.INTEGRATED.getCode())) {
            InspectionApplicationPushEvent event = new InspectionApplicationPushEvent(this, inspectionApplicationModel);
            eventPublisher.publish(event);
        }
    }

    private String getDictNameByCode(String code) {
        DataDictionary dataDictionary = dataDictionaryService.getByCode(code, "JYJC");
        return dataDictionary != null ? dataDictionary.getName() : "";
    }

    /**
     * 退回
     *
     * @param params params
     * @return {@link }
     * @throws
     * @author yangyang
     * @date 2023/12/15 15:14
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean doReject(Map<String, Object> params) {
        String instanceId = params.get("instanceId").toString();
        String nextTaskId = params.get("nextTaskId").toString();
        String lockKey = CommonServiceImpl.buildJcExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForExecuteFlow(nextTaskId, instanceId);
            Long sequenceNbr = Long.parseLong(params.get("sequenceNbr") + "");
            JyjcInspectionApplicationModel model = this.queryBySeq(sequenceNbr);
            ArrayList<String> roleListAll = new ArrayList<>();
            ArrayList<String> roleList = new ArrayList<>();
            String taskId = model.getNextTaskId();
            //组装信息
            TaskResultDTO task = new TaskResultDTO();
            task.setResultCode("approvalStatus");
            task.setTaskId(taskId);
            task.setComment(params.getOrDefault("comments", "").toString());
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", "1");
            task.setVariable(map);
            //执行流程
            task.setNextExecuteUserCompanyCode(model.getInspectionUnitCode());
            ProcessTaskDTO processTaskDTO = cmWorkflowService.reject(taskId, task);
            String nextTaskName = "";
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleList, roleListAll);
            List<WorkflowResultDto> workflowResultDtos = taskModelService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));

            model.setStatus(String.valueOf(FlowStatusEnum.REJECTED.getCode()));
            model.setStatusName(FlowStatusEnum.REJECTED.getName());
            String processDescription = (String) params.get("comments");
            if (StringUtils.isNotBlank(processDescription)) {
                model.setProcessDescription(processDescription);
            }
            String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
            String executorRoleIds = workflowResultDtos.get(0).getExecutorRoleIds();
            nextTaskName = workflowResultDtos.get(0).getNextTaskName();
            nextTaskId = workflowResultDtos.get(0).getNextTaskId();
            model.setNextExecuteIds(String.join(",", roleList));
            if (!org.springframework.util.ObjectUtils.isEmpty(model.getWorkflowRole())) {
                model.setWorkflowRole(model.getWorkflowRole() + "," + String.join(",", roleList));
            } else {
                model.setWorkflowRole(String.join(",", roleList));
            }
            model.setNextTaskId(nextTaskId);
            model.setPromoter(RequestContext.getExeUserId());
            model.setNextTaskName(nextTaskName);
            model.setNextExecuteIds(executorRoleIds);
            model.setNextExecuteUserIds(nextUserIds);
            createNextTask(model, nextTaskName, nextUserIds);
            this.updateWithModel(model);
            // 更新流程中的流程数据
            commonService.saveExecuteFlowData2Redis(model.getProcessInstanceId(), this.buildInstanceRuntimeData(model));
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        return true;
    }


    /**
     * 撤回流程办理单
     */
    public Boolean doRollback(String sequenceNbr, String instanceId, String nextTaskId) {
        String lockKey = CommonServiceImpl.buildJcExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForRevocationFlow(nextTaskId, instanceId);
            JyjcInspectionApplicationModel inspectionApplicationModel = this.queryBySeq(Long.valueOf(sequenceNbr));
            if (inspectionApplicationModel == null) {
                log.warn("JyjcInspectionApplicationModel Not Found！sequenceNbr => " + sequenceNbr);
                return false;
            }
            List<String> roleListNext = new ArrayList<>();
            List<String> roleListAll = new ArrayList<>();
            ProcessTaskDTO processTaskDTO = cmWorkflowService.rollBack(inspectionApplicationModel.getProcessInstanceId());
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleListNext, roleListAll);
            List<WorkflowResultDto> workflowResultDtos = taskModelService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
            if (!org.springframework.util.ObjectUtils.isEmpty(inspectionApplicationModel.getWorkflowRole())) {
                inspectionApplicationModel.setWorkflowRole(inspectionApplicationModel.getWorkflowRole() + "," + roleListAll);
            } else {
                inspectionApplicationModel.setWorkflowRole(inspectionApplicationModel.getWorkflowRole());
            }
            inspectionApplicationModel.setNextTaskId(processTaskDTO.getNextTask().get(0).getId());
            inspectionApplicationModel.setStatus(String.valueOf(FlowStatusEnum.ROLLBACK.getCode()));
            inspectionApplicationModel.setStatusName(FlowStatusEnum.ROLLBACK.getName());
            inspectionApplicationModel.setPromoter("");
            inspectionApplicationModel.setNextExecuteUserIds(workflowResultDtos.get(0).getNextExecutorUserIds());
            inspectionApplicationModel.setNextExecuteIds(String.join(",", roleListNext));
            JyjcInspectionApplication jyjcInspectionApplication = new JyjcInspectionApplication();
            BeanUtils.copyProperties(inspectionApplicationModel, jyjcInspectionApplication);
            this.getBaseMapper().updateById(jyjcInspectionApplication);
            JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(inspectionApplicationModel));
            jsonObject.put("nextTaskId", inspectionApplicationModel.getNextTaskId());
            jsonObject.put("nextExecuteUser", inspectionApplicationModel.getNextExecuteIds());
            jsonObject.put("taskType", BizTypeEnum.getNumByCode(inspectionApplicationModel.getBizType()));
            jsonObject.put("flowStatus", FlowStatusEnum.ROLLBACK.getCode());
            jsonObject.put("flowStatusLabel", FlowStatusEnum.ROLLBACK.getName());
            taskModelService.rollbackTask(inspectionApplicationModel.getProcessInstanceId(), jsonObject);
            // 缓存下一个任务id,再任务进行时，用来校验数据，不再进行数据库查询
            commonService.saveExecuteFlowData2Redis(instanceId, this.buildInstanceRuntimeData(jyjcInspectionApplication));
            return true;
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        return Boolean.FALSE;

    }

    private InstanceRuntimeData buildInstanceRuntimeData(JyjcInspectionApplication jyjcInspectionApplication) {
        return InstanceRuntimeData.builder()
                .nextExecuteUserIds(jyjcInspectionApplication.getNextExecuteUserIds())
                .promoter(jyjcInspectionApplication.getPromoter())
                .nextTaskId(jyjcInspectionApplication.getNextTaskId())
                .build();
    }

    private InstanceRuntimeData buildInstanceRuntimeData(JyjcInspectionApplicationModel jyjcInspectionApplication) {
        return InstanceRuntimeData.builder()
                .nextExecuteUserIds(jyjcInspectionApplication.getNextExecuteUserIds())
                .promoter(jyjcInspectionApplication.getPromoter())
                .nextTaskId(jyjcInspectionApplication.getNextTaskId())
                .build();
    }


    private void buildRoleList(List<ProcessTaskDTO> processTasks, List<String> roleListNext, List<String> roleListAll) {
        processTasks.forEach(p -> {
            p.getNextCandidateGroups().values().forEach(e -> {
                roleListNext.addAll(e);
                roleListAll.addAll(e);
            });
            roleListAll.addAll(p.getCandidateGroups());
        });
    }

    private void createdTaskModel(JyjcInspectionApplicationModel model) {

        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        TaskModelDto dto = new TaskModelDto();
        TaskMessageDto ta = new TaskMessageDto();
        ta.setInstanceId(model.getProcessInstanceId());
        ta.setStatus(model.getStatus());
        ta.setPromoter(model.getPromoter());
        ta.setNextExecuteIds(model.getNextExecuteIds());
        ta.setSequenceNbr(model.getSequenceNbr());
        ta.setProcessInstanceId(model.getProcessInstanceId());
        ta.setProcessKey(model.getProcessKey());
        ta.setInspectionUnitCode(model.getInspectionUnitCode());
        ta.setNextTaskId(model.getNextTaskId());
        ta.setBizType(model.getBizType());
        dto.setModel(ta);
        dto.setFlowCreateDate(new Date());
        dto.setTaskName(model.getNextTaskName());
        dto.setFlowCode(model.getNextTaskId());
        dto.setTaskContent("来自" + model.getEquList() + "【" + model.getSupervisoryCode() + "】的业务办理,【申请单号:" + model.getApplicationNo() + "】");
        dto.setTaskCode(model.getApplicationNo());
        dto.setTaskType(BizTypeEnum.getNumByCode(model.getBizType()));
        dto.setTaskTypeLabel(BizTypeEnum.getNameByCode(model.getBizType()));
        dto.setRelationId(model.getProcessInstanceId());
        dto.setExecuteUserIds(model.getNextExecuteUserIds());
        dto.setTaskStatusLabel("未处理");
        dto.setFlowStatus(Integer.valueOf(model.getStatus()));
        dto.setFlowStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
        dto.setStartUserId(RequestContext.getExeUserId());
        dto.setStartUser(reginParams.getUserModel().getRealName());
        dto.setStartUserCompanyName(reginParams.getCompany().getCompanyName());
        dto.setStartDate(new Date());
        dto.setNextExecuteUser(model.getNextExecuteIds());

        taskModelService.buildTaskModel(Arrays.asList(dto));
    }


    private void createNextTask(JyjcInspectionApplicationModel model, String taskName, String nextUserIds) {
        // 先更新之前的待办
        TaskV2Model taskV2Model = updateTaskModel(model);
        taskV2Model.setTaskDesc("");
        taskV2Model.setTaskName(taskName);
        taskV2Model.setTaskCode(model.getApplicationNo());
        taskV2Model.setExecuteUserIds(nextUserIds);
        taskV2Model.setRelationId(model.getProcessInstanceId());
        taskV2Model.setTaskStatus(Integer.valueOf(model.getStatus()));
        taskV2Model.setTaskStatusLabel(model.getStatusName());
        taskV2Model.setFlowStatus(Integer.valueOf(model.getStatus()));
        taskV2Model.setFlowStatusLabel(model.getStatusName());
        TaskModelDto modelDto = new TaskModelDto();
        BeanUtil.copyProperties(taskV2Model, modelDto);
        modelDto.setNextExecuteUser(model.getNextExecuteIds());
        if (model.getStatus().equals(FlowStatusEnum.REJECTED.getCode() + "")) {
            modelDto.setPageType("edit");
        }
        TaskMessageDto obj = new TaskMessageDto();
        obj.setInstanceId(model.getProcessInstanceId());
        obj.setStatus(model.getStatus());
        obj.setNextTaskId(model.getNextTaskId());
        obj.setPromoter(model.getPromoter());
        obj.setNextExecuteUserIds(model.getNextExecuteUserIds());
        obj.setSequenceNbr(model.getSequenceNbr());
        obj.setNextExecuteIds(model.getNextExecuteIds());
        obj.setProcessInstanceId(model.getProcessInstanceId());
        obj.setProcessKey(model.getProcessKey());
        obj.setInspectionUnitCode(model.getInspectionUnitCode());
        obj.setBizType(model.getBizType());
        obj.setCreateUserId(model.getCreateUserId());
        modelDto.setModel(obj);
        // 再插入新代办、数据待定
        taskModelService.buildTaskModel(Collections.singletonList(modelDto));
    }


    private TaskV2Model updateTaskModel(JyjcInspectionApplicationModel model) {
        Map<String, Object> params = new HashMap<>();
        params.put("relationId", model.getProcessInstanceId());
        params.put("taskStatus", model.getStatus());
        params.put("taskStatusLabel", model.getStatusName());
        params.put("flowStatus", model.getStatus());
        params.put("flowStatusLabel", model.getStatusName());
        params.put("model", model);
        return taskModelService.updateTaskModel(params);
    }


    /**
     * 缓存当前正在流程中的实例的流程数据
     */
    public void initFlowData2Redis() {
        LambdaQueryWrapper<JyjcInspectionApplication> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.ne(JyjcInspectionApplication::getStatus, FlowStatusEnum.TO_BE_FINISHED.getCode());
        queryWrapper.ne(JyjcInspectionApplication::getStatus, FlowStatusEnum.TO_BE_DISCARD.getCode());
        queryWrapper.isNotNull(JyjcInspectionApplication::getProcessInstanceId);
        queryWrapper.select(JyjcInspectionApplication::getProcessInstanceId, JyjcInspectionApplication::getNextTaskId, JyjcInspectionApplication::getPromoter, JyjcInspectionApplication::getNextExecuteUserIds);
        List<JyjcInspectionApplication> jyjcInspectionApplicationsInFlowing = this.list(queryWrapper);
        jyjcInspectionApplicationsInFlowing.forEach(inspectionApplication -> {
            commonService.saveExecuteFlowData2Redis(inspectionApplication.getProcessInstanceId(), this.buildInstanceRuntimeData(inspectionApplication));
        });
    }

    /**
     * 获取当前登录人单位类型
     *
     * @return
     */
    public JSONObject getCompanyType() {

        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        CompanyBo company = reginParams.getCompany();

        JSONObject object = new JSONObject();
        if (!ValidationUtil.isEmpty(company)) {
            object.put("level", company.getLevel());
            object.put("orgCode", company.getOrgCode());
            object.put("companyName", company.getCompanyName());
            object.put("companyCode", company.getCompanyCode());
            CompanyModel result = Privilege.companyClient.queryByCompanyCode(company.getCompanyCode()).getResult();
            if (!ValidationUtil.isEmpty(result)) {
                object.put("companyType", result.getCompanyType());
            }
        }
        return object;
    }

    /**
     * 设备过滤查询-显示未提交的设备、未使用的设备，流程中的设备不显示
     *
     * @param map 查询参数
     * @return 设备分页
     */
    public Page<JSONObject> queryForEquipmentRegisterPage(JSONObject map) {
        int pageNumber = ObjectUtils.isEmpty(map.getInteger("number")) ? 1 : map.getInteger("number");
        int size = ObjectUtils.isEmpty(map.getInteger("size")) ? 20 : map.getInteger("size");
        Page<JSONObject> result = new Page<>(pageNumber, size);
        SearchRequest request = new SearchRequest();
        request.indices("idx_biz_view_jg_all");
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.trackTotalHits(true);
        BoolQueryBuilder boolMust = QueryBuilders.boolQuery();

        // 获取当前登录人单位类型
        JSONObject company = getCompanyType();
        if (ValidationUtil.isEmpty(company)) {
            result.setRecords(new ArrayList<>());
            result.setTotal(0);
            return result;
        }
        String companyCode = company.getString("companyCode").contains("_") ?
                company.getString("companyCode").split("_")[1] : company.getString("companyCode");
        String type = company.getString("companyType");

        // 根据当前登录用户类型及管辖机构筛选条件添加对应参数
        if (!ValidationUtil.isEmpty(type) && type.contains("使用单位")) {
            if (ValidationUtil.isEmpty(map.getString("USE_UNIT_CREDIT_CODE"))) {
                map.put("USE_UNIT_CREDIT_CODE", companyCode);
            }
        }
        if (!ValidationUtil.isEmpty(type) && type.contains("安装改造维修单位")) {
            map.put("USC_UNIT_CREDIT_CODE", companyCode);
        }
        if (!ValidationUtil.isEmpty(type) && type.contains("个人主体")) {
            map.put("USE_UNIT_CREDIT_CODE", companyCode);
        }

        // 默认条件【STATUS==="" || null】
        BoolQueryBuilder meBuilder = QueryBuilders.boolQuery();
        meBuilder.should(QueryBuilders.matchQuery("STATUS", "已认领"));
        meBuilder.should(QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery("STATUS")));
        meBuilder.should(QueryBuilders.boolQuery().must(QueryBuilders.matchPhraseQuery("STATUS", "")));
        meBuilder.minimumShouldMatch(1);
        boolMust.must(meBuilder);

        // DATA_SOURCE 为“jg”的数据（从监管新加的设备）
        // 20240314 提出的监管业务不要让企业用户选到之前一码通认领或补录的设备，让从监管业务中去新增
        BoolQueryBuilder dBuilder = QueryBuilders.boolQuery();
        dBuilder.must(QueryBuilders.prefixQuery("DATA_SOURCE", "jg"));
        boolMust.must(dBuilder);
        // 设备状态
        if (!ObjectUtils.isEmpty(map.getString("EQU_STATE"))) {
            String param = QueryParser.escape(map.getLong("EQU_STATE").toString());
            boolMust.must(QueryBuilders.matchQuery("EQU_STATE", param));
        }

        // 使用单位 //安装改造维修单位
        if (!ObjectUtils.isEmpty(map.getString("USE_UNIT_CREDIT_CODE")) && !ObjectUtils.isEmpty(map.getString("USC_UNIT_CREDIT_CODE"))) {
            BoolQueryBuilder ubuilder = QueryBuilders.boolQuery();
            String useCode = QueryParser.escape(map.getString("USE_UNIT_CREDIT_CODE"));
            useCode = useCode.contains("_") ? useCode.split("_")[0] : useCode;
            ubuilder.should(QueryBuilders.matchQuery("USE_UNIT_CREDIT_CODE", useCode));

            String uscCode = QueryParser.escape(map.getString("USC_UNIT_CREDIT_CODE")).toLowerCase();
            ubuilder.should(QueryBuilders.wildcardQuery("USC_UNIT_CREDIT_CODE", "*" + uscCode + "*"));
            ubuilder.minimumShouldMatch(1);
            boolMust.must(ubuilder);
        } else {
            if (!ObjectUtils.isEmpty(map.getString("USE_UNIT_CREDIT_CODE")) || !ObjectUtils.isEmpty(map.getString("useUnitCreditCode"))) {
                String uucc = !ValidationUtil.isEmpty(map.getString("USE_UNIT_CREDIT_CODE")) ? map.getString("USE_UNIT_CREDIT_CODE") : map.getString("useUnitCreditCode");
                String param = QueryParser.escape(uucc);
                param = param.contains("_") ? param.split("_")[0] : param;
                boolMust.must(QueryBuilders.matchQuery("USE_UNIT_CREDIT_CODE", param));
            }
            if (!ObjectUtils.isEmpty(map.getString("USC_UNIT_CREDIT_CODE"))) {
                String uscCode = QueryParser.escape(map.getString("USC_UNIT_CREDIT_CODE")).toLowerCase();
                boolMust.must(QueryBuilders.wildcardQuery("USC_UNIT_CREDIT_CODE", "*" + uscCode + "*"));
            }
        }
        // 监管码
        if (!ObjectUtils.isEmpty(map.getString("SUPERVISORY_CODE"))) {
            String param = map.getString("SUPERVISORY_CODE");
            List<String> strings = Arrays.asList(param.split(","));
            boolMust.must(QueryBuilders.termsQuery("SUPERVISORY_CODE", strings));
        }
        // 设备种类编码
        if (!ObjectUtils.isEmpty(map.getString("EQU_LIST_CODE"))) {
            boolMust.must(QueryBuilders.termsQuery("EQU_LIST_CODE", QueryParser.escape(map.getString("EQU_LIST_CODE"))));
        }
        // 设备类别
        if (!ObjectUtils.isEmpty(map.getString("EQU_CATEGORY_CODE"))) {
            boolMust.must(QueryBuilders.termQuery("EQU_CATEGORY_CODE", QueryParser.escape(map.getString("EQU_CATEGORY_CODE"))));
        }
        // 设备类别编码
        if (!ObjectUtils.isEmpty(map.getString("EQU_DEFINE_CODE"))) {
            boolMust.must(QueryBuilders.matchPhraseQuery("EQU_DEFINE_CODE", QueryParser.escape(map.getString("EQU_DEFINE_CODE"))));
        }
        // 设备代码模糊查询
        if (!ObjectUtils.isEmpty(map.getString(EQU_CODE))) {
            String test = QueryParser.escape(map.getString(EQU_CODE));
            boolMust.must(QueryBuilders.wildcardQuery(EQU_CODE, "*" + test.toLowerCase() + "*"));
        }
        // 单位内部编号模糊查询
        if (!ObjectUtils.isEmpty(map.getString("USE_INNER_CODE"))) {
            String test = QueryParser.escape(map.getString("USE_INNER_CODE"));
            boolMust.must(QueryBuilders.wildcardQuery("USE_INNER_CODE", "*" + test.toLowerCase() + "*"));
        }
        this.setFilterOfInFlowing(boolMust);
        builder.query(boolMust);
        builder.sort("REC_DATE", SortOrder.DESC);
        builder.from((pageNumber - 1) * size);
        builder.size(size);
        request.source(builder);
        List<JSONObject> list = new LinkedList<>();
        long totle = 0;
        if (log.isDebugEnabled()) {
            log.debug("查询es 的查询条件: {}", request);
        }
        try {
            SearchResponse response = restHighLevelClient.search(request, RequestOptions.DEFAULT);
            for (SearchHit hit : response.getHits().getHits()) {
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(hit);
                JSONObject dto2 = jsonObject.getJSONObject("sourceAsMap");
                if (!ValidationUtil.isEmpty(dto2.get(EQU_STATE))) {
                    Integer integer = Integer.valueOf(dto2.get(EQU_STATE).toString());
                    String status = EquimentEnum.getName.get(integer);
                    dto2.put(EQU_STATE, status);
                }
                dto2.put("record", dto2.get(SEQUENCE_NBR));
                list.add(dto2);
            }
            // 填充地址
            fillAddress(list);
            totle = response.getInternalResponse().hits().getTotalHits().value;
            result.setRecords(list);
            result.setTotal(totle);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    /**
     * 过滤条件去掉流程中的设备
     *
     * @param boolMust 条件
     */
    private void setFilterOfInFlowing(BoolQueryBuilder boolMust) {
        Set<String> records = this.getEquipInFlowing();
        if (records != null && !records.isEmpty()) {
            boolMust.mustNot(QueryBuilders.termsQuery("SEQUENCE_NBR.keyword", records));
        }
    }

    private Set<String> getEquipInFlowing() {
        return this.getBaseMapper().queryRecordInFlowing();
    }

    private void fillAddress(List<JSONObject> list) {
        // 获取所有设备的Id
        List<String> equIds = null;
        if (!ValidationUtil.isEmpty(list)) {
            equIds = list.stream().map(item -> item.get(SEQUENCE_NBR).toString()).collect(Collectors.toList());
        }
        if (!ValidationUtil.isEmpty(equIds)) {
            // 查询设备地址
            List<IdxBizJgUseInfo> useInfoListByEquIds = this.getUseInfoListByEquIds(equIds);
            Map<String, String> equAddressMap = new HashMap<>();
            if (!ValidationUtil.isEmpty(useInfoListByEquIds)) {
                equAddressMap = useInfoListByEquIds.stream().collect(Collectors.toMap(IdxBizJgUseInfo::getRecord,
                        useInfo -> {
                            String fulladdress = "";
                            if (!ValidationUtil.isEmpty(useInfo.getProvinceName())) {
                                fulladdress += useInfo.getProvinceName();
                            }
                            if (!ValidationUtil.isEmpty(useInfo.getCityName())) {
                                fulladdress += useInfo.getCityName();
                            }
                            if (!ValidationUtil.isEmpty(useInfo.getCountyName())) {
                                fulladdress += useInfo.getCountyName();
                            }
                            if (!ValidationUtil.isEmpty(useInfo.getStreetName())) {
                                fulladdress += useInfo.getStreetName();
                            }
                            if (!ValidationUtil.isEmpty(useInfo.getAddress())) {
                                fulladdress += useInfo.getAddress();
                            }
                            return fulladdress;
                        }
                        )
                );
            }
            // 更新设备使用情况和设备地址
            for (JSONObject item : list) {
                String fullAddress = equAddressMap.get(item.getString(SEQUENCE_NBR));
                item.put("ADDRESS", !ValidationUtil.isEmpty(fullAddress) ? fullAddress : "");
            }
        }
    }

    private List<IdxBizJgUseInfo> getUseInfoListByEquIds(List<String> equIds) {
        QueryWrapper<IdxBizJgUseInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().in(IdxBizJgUseInfo::getRecord, equIds);
        return jgUseInfoMapper.selectList(queryWrapper);
    }
}