package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.entity.FireTeam;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* 消防队伍 Mapper 接口
*
* @author tb
* @date 2021-06-07
*/
public interface FireTeamMapper extends BaseMapper<FireTeam> {

//	@Select("<script>"
//	+ "select a.sequence_nbr sequenceNbr, a.img,a.name,a.contact_user contactUser,a.contact_phone contactPhone, a.address from cb_fire_team a  where a.is_delete=0"
//	+ "<if test='par.parent!=null'>" + "and a.parent= #{par.parent}" + "</if>"
//	+ "<if test='par.typeCode!=null'>" + "and a.type_code= #{par.typeCode}" + "</if>"
//	+ "<if test='par.companyCode!=null'>" + "and a.company_code= #{par.companyCode}" + "</if>"
//	+ "<if test='par.name!=null'>" + "and a.name= #{par.name}" + "</if>"
//	+ "</script>")
//	List<FireTeamVo> getFireTeam(int pageNum, int pageSize, FireTeamListVo par);
//	@Select("<script>"
//	+ "select COUNT(a.sequence_nbr) num from cb_fire_team a  where a.is_delete=0"
//	+ "<if test='par.parent!=null'>" + "and a.parent= #{par.parent}" + "</if>"
//	+ "<if test='par.typeCode!=null'>" + "and a.type_code= #{par.typeCode}" + "</if>"
//	+ "<if test='par.companyCode!=null'>" + "and a.company_code= #{par.companyCode}" + "</if>"
//	+ "<if test='par.name!=null'>" + " and a.name= #{par.name}" + "</if>"
//	+ "</script>")
//	Map<String, Long> getFireTeamCount(int pageNum, int pageSize, FireTeamListVo par);

	/**
	 * 返回监控大队信息列表
	 *
	 * @return
	 */
	List<FireBrigadeResourceDto> listMonitorFireBrigade(@Param("code") String code );

	/**
	 * 查询消防队伍卡片分页列表
	 *
	 * @param page
	 * @param par
	 * @return
	 */
	IPage<FireTeamCardDto> getFireTeamForPage(Page page, FireTeamListDto par);


	/**
	 * 根据队伍id查询队伍下人员列表
	 *
	 * @param teamIds
	 * @return
	 */
	List<FirefightersDto> queryFighterByTeamId(@Param("teamIds") List<String> teamIds);

	/**
	 * 根据当前队伍id查询该队伍下所有子队伍
	 *
	 * @param teamId
	 * @return
	 */
	List<FireTeam> listFireTeamById(Long teamId);



	/***
	 *
	 *  指挥队伍资源 列表
	 *
	 * **/
	List<FireTeamZhDto> getFireTeamList(@Param("pageNum")int pageNum, @Param("pageSize")int pageSize, @Param("par") RequestData par);

	/***
	 *
	 *  指挥队伍资源 统计
	 *
	 * **/
	Integer getFireTeamListCount(@Param("par")RequestData par);





	List<FireTeamZhDto> getFireTeamCountList();


	/**
	 * 根据teamId 返回队伍底下人员数量
	 * @param teamId
	 * @return
	 */
	Integer getFighterNumByTeamId(Long teamId);

	/**
	 * 根据companyCode 返回机构下所有的队伍
	 * @param teamId
	 * @return
	 */
	List<FireTeam> byTeamId(Long teamId);

	List<FireTeamDto> listFireTeamDto(Boolean isDelete, String nodeId, String nodeType, String name, String typeCode,List<String> nodeIds, String bizOrgCode);

	List<FireTeamDto> listFireTeamDtoTree(Boolean isDelete);


}
