package com.yeejoin.amos.avic.controller;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.avic.face.model.AvicCustomPathModel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@TycloudResource(module = "avic", value = "FileFransfer")
@RequestMapping(value = "/v1/avic/WebServicesFileFransfer")
@Api(tags = "avic-")
public class WebServicesFileFransferResource {
	private final Logger logger = LogManager.getLogger(WebServicesFileFransferResource.class);
	@Value("${avic.webservice.path}")
	String webserviceUrl;

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "传输文件")
	@RequestMapping(value = "/file", method = RequestMethod.POST)
	public ResponseModel postfile() {
		JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
		Client client = dcf.createClient(webserviceUrl);
		try {
			// invoke("方法名",参数1,参数2,参数3....);
			client.invoke("transferFile", "张三");
		} catch (java.lang.Exception e) {
			e.printStackTrace();
		}
		return ResponseHelper.buildResponse(null);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "传输目录配置")
	@RequestMapping(value = "/config", method = RequestMethod.POST)
	public ResponseModel postConfig(@RequestBody AvicCustomPathModel model) {
		JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
		Client client = dcf.createClient(webserviceUrl);
		try {
			client.invoke("transferPathConfig", model);
		} catch (java.lang.Exception e) {
			e.printStackTrace();
		}
		return ResponseHelper.buildResponse(null);
	}
}
