package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.yeejoin.amos.boot.module.ccs.api.dto.FireStationInfoDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireStationInfo;
import com.yeejoin.amos.boot.module.ccs.api.enums.StationOrderByTypeEnum;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireStationInfoMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireStationInfoService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Optional;

/**
 * 站端信息表服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireStationInfoServiceImpl extends BaseService<FireStationInfoDto, FireStationInfo, FireStationInfoMapper> implements IFireStationInfoService {
    /**
     * 列表查询 示例
     *
     * @param orderBy
     */
    public List<FireStationInfoDto> queryForFireStationInfoList(String orderBy) throws Exception {
        if (StringUtils.isNotBlank(orderBy)) {
            Optional<StationOrderByTypeEnum> op = StationOrderByTypeEnum.getEnum(orderBy);
            op.orElseThrow(() -> new Exception("不存在查询排序条件"));
            return this.baseMapper.queryStationListWithStatistics(op.get().getOrderBy());
        } else {
            return this.baseMapper.queryStationListWithStatistics(null);
        }
    }

    @Override
    public FireStationInfoDto getOneByCode(String code) {
        List<FireStationInfoDto> dtos = this.queryForList("", false, code);
        if (dtos.isEmpty()) {
            throw new RuntimeException("不存在指定数据");
        }
        return dtos.iterator().next();
    }
}