package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.EquipmentSpecificIndexMapper;
import com.yeejoin.amos.fas.business.dao.mapper.PollPointMapper;
import com.yeejoin.amos.fas.business.service.intfc.EquipmentSpecificIndexService;
import com.yeejoin.amos.fas.business.vo.EquipmentSpecificIndexVo;
import com.yeejoin.amos.fas.business.vo.PollPointVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ProjectName: YeeAmosFireAutoSysRoot
 * @Package: com.yeejoin.amos.fas.business.service.impl
 * @ClassName: EquipmentSpecificIndexServiceImpl
 * @Author: Jianqiang Gao
 * @Description:    EquipmentSpecificIndexServiceImpl
 * @Date: 2021/1/18 16:35
 * @Version: 1.0
 */
@Service
public class EquipmentSpecificIndexServiceImpl implements EquipmentSpecificIndexService {

    @Autowired
    private EquipmentSpecificIndexMapper equipmentSpecificIndexMapper;

    @Autowired
    private PollPointMapper pollPointMapper;

    @Override
    public Map<String, Object> queryInitAlarm(String value, String nameKeys, String status) {
        Map<String, Object> map = new HashMap<>(16);
        //  查询设备告警
        List<EquipmentSpecificIndexVo> equipmentSpecificAlarmVoList = equipmentSpecificIndexMapper.queryInitAlarm(value, nameKeys.split(","));
        map.put("equip", equipmentSpecificAlarmVoList);
        //  查询巡检告警
        List<PollPointVo> pollPointVoList =  pollPointMapper.queryInitAlarm(status.split(","));
        map.put("poll", pollPointVoList);
        return map;
    }

    @Override
    public List<EquipmentSpecificIndexVo> getInitAlarm(String value, String nameKeys, String status) {
        //  查询设备告警
        List<EquipmentSpecificIndexVo> equipmentSpecificAlarmVoList = equipmentSpecificIndexMapper.getInitAlarm(value, nameKeys.split(","));
        //  查询巡检告警
        List<EquipmentSpecificIndexVo> pollPointVoList =  pollPointMapper.getInitAlarm(status.split(","));
        pollPointVoList.stream().sequential().collect(Collectors.toCollection(() -> equipmentSpecificAlarmVoList));
        return equipmentSpecificAlarmVoList;
    }
}