package com.yeejoin.amos.api.openapi.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 设备信息
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SpecialEquModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 必填，监察为准，原码保持
     */
    private String sequenceCode;
    /**
     * 系统设备ID
     */
    private String equiId;
    /**
     * 注册状态
     */
    private String registerState;
    /**
     * 使用状态
     */
    private String useState;
    /**
     * 注册登记机构
     */
    private String registerOrg;
    /**
     * 注册登记日期
     */
    private String registerDate;
    /**
     * 设备注册代码
     */
    private String equRegisterCode;
    /**
     * 注册登记人员
     */
    private String registerUser;
    /**
     * 使用登记证编号
     */
    private String useCode;
    /**
     * 发证类型
     */
    private String certificatesType;
    /**
     * 发证机构
     */
    private String certificatesOrg;
    /**
     * 发证日期
     */
    private String certificatesDate;
    /**
     * 首次发证日期
     */
    private String firstCertificatesDate;
    /**
     * 有效期至
     */
    private String validUntilDate;
    /**
     * 设备类别
     */
    private String equCategory;
    /**
     * 设备类别代码
     */
    private String equCategoryCode;
    /**
     * 设备品种
     */
    private String equDefine;
    /**
     * 产品名称
     */
    private String productName;
    /**
     * 产品编号
     */
    private String productCode;
    /**
     * 设备代码
     */
    private String equCode;
    /**
     * 型号（规格）
     */
    private String equType;
    /**
     * 设计使用年限
     */
    private String designUseYears;
    /**
     * 设计单位名称
     */
    private String designUnitName;
    /**
     * 设计单位统一信用代码
     */
    private String designUnitCreditCode;
    /**
     * 制造单位名称
     */
    private String manufactureUnitName;
    /**
     * 制造单位统一信用代码
     */
    private String manufactureUnitCreditCode;
    /**
     * 施工单位名称
     */
    private String constructionUnitName;
    /**
     * 施工单位统一信用代码
     */
    private String constructionUnitCreditCode;
    /**
     * 制造日期
     */
    private String manufactureDate;
    /**
     * 监督检验机构名称
     */
    private String supervisionInspectionOrgName;
    /**
     * 型式试验机构名称
     */
    private String typeTestOrgName;
    /**
     * 固定检验地址
     */
    private String fixedInspectionAddress;
    /**
     * 维保单位
     */
    private String maintenanceUnit;
    /**
     * 维保单位统一信用代码
     */
    private String maintenanceUnitCreditCode;
    /**
     * 应急救援电话
     */
    private String emergencyRescuePhone;
    /**
     * 使用单位名称
     */
    private String useUnitName;
    /**
     * 所在地区代码
     */
    private String regionCode;
    /**
     * 使用单位地址
     */
    private String useUnitAddress;
    /**
     * 使用单位统一社会信用代码
     */
    private String useUnitCreditCode;
    /**
     * 邮政编码
     */
    private String postalCode;
    /**
     * 单位内编号
     */
    private String unitInnerCode;
    /**
     * 设备使用地点
     */
    private String equUseAddress;
    /**
     * 投入使用日期
     */
    private String investUseDate;
    /**
     * 单位固定电话
     */
    private String unitFixedPhone;
    /**
     * 安全管理员
     */
    private String safeOfficer;
    /**
     * 安全管理联系电话
     */
    private String safeOfficerPhone;
    /**
     * 产权单位
     */
    private String ownerUnit;
    /**
     * 产权单位统一社会信用代码
     */
    private String ownerUnitCreditCode;
    /**
     * 联系电话
     */
    private String phone;
    /**
     * 经度
     */
    private String longitude;
    /**
     * 纬度
     */
    private String latitude;

}
