package com.yeejoin.amos.boot.module.app.api.mapper;

import com.yeejoin.amos.boot.biz.common.dto.JgUseRegistrationManageDto;
import com.yeejoin.amos.boot.module.app.api.dto.CylinderInfoForWX;
import com.yeejoin.amos.boot.module.app.api.dto.VehicleInfoForWX;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-13
 */
@Mapper
public interface AppCommonMapper {

    /**
     * 查询指定单号下的车用气瓶信息
     *
     * @param applyNo 单号
     * @return 车用气瓶信息
     */
    List<CylinderInfoForWX> queryCylinderIfoOfVehicle(String applyNo);


    /**
     * 查询车辆基本信息
     *
     * @param seq 主键
     * @return 车辆基本信息
     */
    VehicleInfoForWX queryVehicleBaseInfo(Long seq);

    JgUseRegistrationManageDto selectOneCert(String certOrApplyNo);

    JgUseRegistrationManageDto searchOneCertByParam(String certNo);
}
