package com.yeejoin.amos.boot.module.jyjc.biz.message.factoty;

import com.yeejoin.amos.boot.module.jyjc.biz.message.open.IOpenApplicationMsgHandler;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
@RequiredArgsConstructor
@Slf4j
public class OpenAppMsgFactory {
    private final List<IOpenApplicationMsgHandler> openAppMsgHandlers;
    private final Map<String, IOpenApplicationMsgHandler> msgHandlerMap = new ConcurrentHashMap<>();

    public IOpenApplicationMsgHandler getOpenAppMsgHandler(String state) {
        return msgHandlerMap.computeIfAbsent(state, k -> {
            for (IOpenApplicationMsgHandler handler : openAppMsgHandlers) {
                if (handler.supportState().equals(state)) {
                    return handler;
                }
            }
            return new IOpenApplicationMsgHandler() {
                @Override
                public String supportState() {
                    return "";
                }

                @Override
                public void handle(String userId, String relationId, String companyType) {
                    log.error("no support state:{} ", state);
                }
            };
        });
    }
}
