package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.statistcs.biz.service.ITzsCustomFilterService;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.TzsCustomFilterServiceImpl;
import com.yeejoin.amos.boot.module.statistics.api.dto.TzsCustomFilterDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 自定义筛选字段基础数据表
 *
 * @author system_generator
 * @date 2025-06-24
 */
@RestController
@Api(tags = "自定义筛选字段基础数据表Api")
@RequestMapping(value = "/tzs-custom-filter")
public class TzsCustomFilterController extends BaseController {

    @Autowired
    TzsCustomFilterServiceImpl tzsCustomFilterServiceImpl;

	@Autowired
	ITzsCustomFilterService	tzsCustomFilterService;

    /**
     * 新增自定义筛选字段基础数据表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增自定义筛选字段基础数据表", notes = "新增自定义筛选字段基础数据表")
	public ResponseModel<TzsCustomFilterDto> save(@RequestBody TzsCustomFilterDto model) {
	    model = tzsCustomFilterServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新自定义筛选字段基础数据表", notes = "根据sequenceNbr更新自定义筛选字段基础数据表")
	public ResponseModel<TzsCustomFilterDto> updateBySequenceNbrTzsCustomFilter(@RequestBody TzsCustomFilterDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(tzsCustomFilterServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除自定义筛选字段基础数据表", notes = "根据sequenceNbr删除自定义筛选字段基础数据表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(tzsCustomFilterServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个自定义筛选字段基础数据表",  notes = "根据sequenceNbr查询单个自定义筛选字段基础数据表")
	public ResponseModel<TzsCustomFilterDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(tzsCustomFilterServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "自定义筛选字段基础数据表分页查询",  notes = "自定义筛选字段基础数据表分页查询")
	public ResponseModel<Page<TzsCustomFilterDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<TzsCustomFilterDto> page = new Page<TzsCustomFilterDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(tzsCustomFilterService.queryForTzsCustomFilterPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "自定义筛选字段基础数据表列表全部数据查询",   notes = "自定义筛选字段基础数据表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<TzsCustomFilterDto>> selectForList() {
	    return ResponseHelper.buildResponse(tzsCustomFilterService.queryForTzsCustomFilterList());
	}
}
