package com.yeejoin.amos.boot.module.ymt.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ymt.api.dto.ElevatorAlarmDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.ElevatorAlarm;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.ElevatorAlarmServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 
 *
 * @author litw
 * @date 2021-09-28
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/elevator-alarm")
public class ElevatorAlarmController extends BaseController {

    @Autowired
    ElevatorAlarmServiceImpl elevatorAlarmServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<ElevatorAlarmDto> save(@RequestBody ElevatorAlarmDto model) {
	    model = elevatorAlarmServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<ElevatorAlarmDto> updateBySequenceNbrElevatorAlarm(@RequestBody ElevatorAlarmDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(elevatorAlarmServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(elevatorAlarmServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<ElevatorAlarmDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(elevatorAlarmServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<ElevatorAlarmDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<ElevatorAlarmDto> page = new Page<ElevatorAlarmDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(elevatorAlarmServiceImpl.queryForElevatorAlarmPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<ElevatorAlarmDto>> selectForList() {
	    return ResponseHelper.buildResponse(elevatorAlarmServiceImpl.queryForElevatorAlarmList());
	}

	/**
	 * 根据电梯注册码查询物联信息
	 *
	 * @param registerCode  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getElevatorStatus")
	@ApiOperation(httpMethod = "GET",value = "根据电梯注册码查询物联信息",  notes = "根据电梯注册码查询物联信息")
	public ResponseModel<ElevatorAlarmDto> selectOne(@RequestParam String registerCode) {
		LambdaQueryWrapper<ElevatorAlarm> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(ElevatorAlarm::getRegisterCode,registerCode);
		queryWrapper.orderByDesc(ElevatorAlarm::getStartDate);
		List<ElevatorAlarm>  elevatorStatus = elevatorAlarmServiceImpl.list(queryWrapper);
		if(null != elevatorStatus && elevatorStatus.size() > 0) {
			ElevatorAlarmDto dto = new ElevatorAlarmDto();
			Bean.toPo(elevatorStatus.get(0),dto);

			return  ResponseHelper.buildResponse(dto);
		}

		return ResponseHelper.buildResponse(null);
	}

}
