package com.yeejoin.amos.boot.module.ymt.biz.controller;

import com.yeejoin.amos.boot.module.ymt.biz.service.impl.RescueProcessServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.ymt.api.dto.RescueProcessDto;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 救援过程表
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "救援过程表Api")
@RequestMapping(value = "/rescue-process")
public class RescueProcessController extends BaseController {

    @Autowired
    RescueProcessServiceImpl rescueProcessServiceImpl;


	@Autowired
	RedisUtils redisUtils;

	/**
	 * 根据警情id 更新救援信息表
	 * @param model
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/updateByAlertId")
	@ApiOperation(httpMethod = "POST", value = "根据警情id 更新救援信息表", notes = "根据警情id 更新救援信息表")
	public ResponseModel<Boolean> save(@RequestBody RescueProcessDto model) {
		ReginParams reginParams =getSelectedOrgInfo();
		boolean update = rescueProcessServiceImpl.updateByAlertId(model,reginParams.getUserModel());
		return ResponseHelper.buildResponse(update);
	}


	/**
	 * 根据警情id 获取救援过程表
	 * @param alertId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/alert/{alertId}")
	@ApiOperation(httpMethod = "GET",value = "根据警情id 获取救援过程表",  notes = "根据警情id 获取救援过程表")
	public ResponseModel<RescueProcessDto> selectOne(@PathVariable Long alertId) {
		ReginParams reginParams =getSelectedOrgInfo();
		AgencyUserModel user = reginParams.getUserModel();
		RescueProcessDto dto = rescueProcessServiceImpl.getProcessByAlertId(alertId);
		if(dto.getDispatchUserId() == null && dto.getDispatchUserName() == null) {
			dto.setDispatchUserId(user.getUserId());
			dto.setDispatchUserName(user.getRealName());
		}
		if(dto.getArriveUserId() == null && dto.getArriveUserName() == null) {
			dto.setArriveUserId(user.getUserId());
			dto.setArriveUserName(user.getRealName());
		}
		if(dto.getRescueUserId() == null && dto.getRescueUserName() == null) {
			dto.setRescueUserId(user.getUserId());
			dto.setRescueUserName(user.getRealName());
		}
	    return ResponseHelper.buildResponse(dto);
	}

}
