package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.entity.WaterResource;
import org.apache.ibatis.annotations.Param;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2021-06-29
 */
public interface WaterResourceMapper extends BaseMapper<WaterResource> {

    List<WaterResourceForExportDto> exportToExcel(@Param("isDelete")Boolean isDelete, @Param("name")String name, @Param("resourceType")String resourceType, @Param("bizOrgCode")String bizOrgCode);


    /***
     *
     *  指挥水源资源 列表
     *
     * **/
    List<WaterResourceZhDto> getWaterResourceList(@Param("pageNum")int pageNum, @Param("pageSize")int pageSize, @Param("par") RequestData par);

    /***
     *
     *  指挥水源资源统计
     *
     * **/
    Integer getWaterResourceListCount(@Param("par")RequestData par);


    List<WaterResourceTypeDto> getWaterResourceTypeList(Boolean isDelete);

    /**
     *  根据参数查询
     *
     */
    Page<WaterResourceDto> getWaterResourcePageByParams(Page<WaterResourceDto> page, String name, String resourceType,
                                                        ArrayList<Long> belongBuildingId, Long belongFightingSystemId,
                                                        Long sequenceNbr, String equipId,String bizOrgCode, String equipCateGoryCode,List<String> ids);

    List<Map<String, Object>> getWaterTypeByBizOrgCode(String bizOrgCode);

    Page<WaterResourceDto> pageByDefect(Page<WaterResourceDto> page, @Param("nameOrCode") String nameOrCode, @Param("bizOrgCode") String bizOrgCode, @Param("systemName") String systemName);
}
