package com.yeejoin.precontrol.common.enums;

public enum TaskFeedBackEnum {

	NOT_RECEIVED(0, "未收到"),

    AMOUNT_DIFFER(1, "金额不符"),

    OTHER(2, "其他"),;

    private int type;

    private String name;

    TaskFeedBackEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public static String getNameByType(int type) {
        String name = null;
        for (TaskFeedBackEnum enumOne : TaskFeedBackEnum.values()) {
            if (enumOne.getType() == type) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }
}
