package com.yeejoin.precontrol.common.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.annotations.TableFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class PersonVo implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    @ImagePrefix
    private String headPhoto;
    private String name;
    private Long sex;
    private String sexLabel;
    @ApiModelProperty(value = "身份证")
    private String idnumber;
    @ApiModelProperty(value = "民族")
    private String folkKey;
    @ApiModelProperty(value = "籍贯")
    private String nativePlace;
    private String phone;
    @TableFormat(entityName = "rpm_project", fieldName = "name", operFieldName = "projectName")
    private Long projectId;
    private String projectName;
    @TableFormat(entityName = "rpm_company", fieldName = "name", operFieldName = "companyName")
    private Long companyId;
    private String companyName;
    @ApiModelProperty(value = "在场状态")
    private String status;
    private String statusLabel;
    private String skillLevelKey;
    private String skillLevelLabel;
    @ApiModelProperty(value = "考核成绩")
    private Integer examineScore;
    @ApiModelProperty(value = "平台账号userId")
    private Long userId;
    @ApiModelProperty(value = "平台账号")
    private String accountName;
    @ApiModelProperty(value = "岗位名称")
    private String postName;
    @ApiModelProperty(value = "岗位名称")
    private Boolean inJob;
    @ApiModelProperty(value = "二维码颜色")
    private Long color;
    @ApiModelProperty(value = "是否合格")
    private Boolean qualified;
    private String qualifiedName;

    @ApiModelProperty(value = "用户角色名称")
    private String roleName;
    @ApiModelProperty(value = "用户角色key")
    private String roleKey;
    @ApiModelProperty(value = "黑名单")
    private Boolean isBlack;

    private String orgCode;
    @ApiModelProperty(value = "激活状态，用于出入场")
    private Long activeStatus;

    @ApiModelProperty(value = "是否是江西电建")
    private boolean isJxdj;
    
    @ApiModelProperty(value = "工号")
    private String jobNumber;
    
    @ApiModelProperty(value = "出勤天数")
    private int clockDays;
    
    @ApiModelProperty(value = "计算考勤开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date clockStartDate;
    
    @ApiModelProperty(value = "计算考勤结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date clockEndDate;

    @ApiModelProperty(value = "薪资")
    private BigDecimal salary;
    
    @ApiModelProperty(value = "阅读状态")
    private Long readStatus;
    
    @ApiModelProperty(value = "阅读状态")
    private Long taskPersonId;
    
    @ApiModelProperty(value = "反馈列表")
    private List<TaskPersonFeedbackVo> feedbackList;
    
    @ApiModelProperty(value="部门名称")
    private String departmentName;
    
    @ApiModelProperty(value="政治面貌")
    private String politicCountenance;
    
    @ApiModelProperty(value="工作时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date workTime;
    
    @ApiModelProperty(value="现学历")
    private String currentEducationKey;

    @ApiModelProperty(value = "审核状态：,1-待审核，2-审核拒绝，3-审核通过")
    private Integer verifyStatus;
    
	@ApiModelProperty(value = "openId")
	private String openId;
}
