package com.yeejoin.equipmanage.controller;

import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.entity.Warehouse;
import com.yeejoin.equipmanage.common.vo.AreaTreeVo;
import com.yeejoin.equipmanage.common.vo.UnitAreaTreeVo;
import com.yeejoin.equipmanage.service.IFormInstanceService;
import com.yeejoin.equipmanage.service.IWarehouseService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.WarehouseStructure;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.service.IWarehouseStructureService;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 货架结构
 *
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "货架结构Api")
@RequestMapping(value = "/warehouse-structure", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class WarehouseStructureController extends AbstractBaseController {

	@Autowired
	IWarehouseStructureService iWarehouseStructureService;
	@Autowired
	IWarehouseService warehouseService;
	@Autowired
	IFormInstanceService iFormInstanceService;

	/**
	 * 新增货架结构
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "新增货架结构", notes = "新增货架结构")
	public WarehouseStructure saveWarehouseStructure(HttpServletRequest request,
			@RequestBody WarehouseStructure warehouseStructure) {
		return iWarehouseStructureService.saveOne(warehouseStructure);
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) throws Exception {
		return iWarehouseStructureService.removeOneById(id);
	}

	/**
	 * 修改货架结构
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "PUT", value = "修改货架结构", notes = "修改货架结构")
	public WarehouseStructure updateByIdWarehouseStructure(HttpServletRequest request,
			@RequestBody WarehouseStructure warehouseStructure) {
		return iWarehouseStructureService.updateOneById(warehouseStructure);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public WarehouseStructure selectById(HttpServletRequest request, @PathVariable Long id) {
		return iWarehouseStructureService.getById(id);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<WarehouseStructure> listPage(String pageNum, String pageSize, WarehouseStructure warehouseStructure) {

		Page<WarehouseStructure> pageBean;
		QueryWrapper<WarehouseStructure> warehouseStructureQueryWrapper = new QueryWrapper<>();
		Class<? extends WarehouseStructure> aClass = warehouseStructure.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(warehouseStructure);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(warehouseStructure);
						warehouseStructureQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(warehouseStructure);
						warehouseStructureQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(warehouseStructure);
						warehouseStructureQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(warehouseStructure);
						warehouseStructureQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<WarehouseStructure> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iWarehouseStructureService.page(pageBean, warehouseStructureQueryWrapper);
		return page;
	}

	/**
	 * 查询所有列表
	 *
	 * @return
	 */
	@GetMapping(value = "/listAll")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询所有列表", notes = "查询所有列表")
	public List<WarehouseStructure> listAll() {
		return iWarehouseStructureService.list();
	}

	/**
	 * 树查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/tree/{id}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "树查询", notes = "树查询")
	public List<WarehouseStructure> tree(@PathVariable Long id) {
		if (id == null) {
			List<Warehouse> list = warehouseService.list();
			if (list.size() > 0) {
				id = list.get(0).getId();
			} else {
				id = 0L;
			}
		}
		return iWarehouseStructureService.tree(id);
	}

	@RequestMapping(value = "/gettree/{id}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "树查询", notes = "树查询")
	public List<WarehouseStructure> gettree(@PathVariable Long id,String bizOrgCode) {

		return iWarehouseStructureService.gettree(id,bizOrgCode);
	}

	/**
	 * 批量删除
	 * 
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.DELETE)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean delete(HttpServletRequest request, @RequestBody List<Long> idList) throws Exception {
		return iWarehouseStructureService.removeBatchById(idList);
	}

	/**
	 * 根据source_id查询 wl_form_instance中的field_value
	 */
	@RequestMapping(value = "/getValueByColumn", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据source_id查询区域树", notes = "根据id查询")
	public List<UnitAreaTreeVo> getValueByColumn(@RequestParam Long sourceId) {
		// 获取登陆人角色
		String orgcode = getOrgCode();
		return iFormInstanceService.getValueByColumn(sourceId, orgcode);
	}
	/**
	 */
	@RequestMapping(value = "/getWarehouseStructureByCode", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据code查询建筑id", notes = "根据code查询建筑id")
	public Long getWarehouseStructureByCode(@RequestParam String code) {
		QueryWrapper<WarehouseStructure> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("code",code);
		WarehouseStructure one = iWarehouseStructureService.getOne(queryWrapper);
		if(null == one) {
			return null;
		}
		return one.getSourceId();
	}
}


