package com.yeejoin.amos.patrol.dao.entity;

import java.sql.Time;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.springframework.data.annotation.LastModifiedDate;


/**
 * The persistent class for the p_plan database table.
 * 
 */
@Entity
@Table(name="p_plan")
@NamedQuery(name="Plan.findAll", query="SELECT p FROM Plan p")
public class Plan extends BasicEntity {
	private static final long serialVersionUID = 1L;
	/**
	 * 部门id
	 */
	@Column(name="dept_id")
	private String deptId;
	/**
     * 创建者
     */
	@Column(name="create_by")
	private String createBy;
	
	/**
     * 开始时间
     */
	@Column(name="day_begin")
	private Time dayBegin;
	/**
     * 结束时间
     */
	@Column(name="day_end")
	private Time dayEnd;
	/**
     * 执行间隔（每天执行频率为多次时使用）
     */
	@Column(name="day_interval")
	private int dayInterval;
	/**
     * 执行间隔单位：小时，分钟，秒
     */
	@Column(name="day_interval_unit")
	private String dayIntervalUnit;
	/**
     * 每天频率：0-一次；1-多次
     */
	@Column(name="day_rate")
	private int dayRate = -1;
	/**
     * 开始时间（执行频率为一次时，使用）
     */
	@Column(name="day_time")
	private String dayTime;
	/**
     * 工作时长（分钟）
     */
	private int duration;
	
	/**
     * 首次标志
     */
	private int firstFlag;
	/**
     * 允许误差(分钟)
     */
	private int error;
	/**
     * 执行频率（年计划使用）
     */
	@Column(name="execute_rate")
	private int executeRate;
	/**
     * 排序
     */
	@Column(name="in_order")
	private String inOrder;
	
	/**
     * 执行间隔
     */
	@Column(name="execute_interval")
	private int executeInterval;
	/**
     * 是否固定巡检日期：0-否；1-是
     */
	@Column(name="is_fixed_date")
	private String isFixedDate;
	/**
     * 是否评分
     */
	@Column(name="is_score")
	private String isScore;
	/**
     * 最近更新者
     */
	@Column(name="last_upd_by")
	private String lastUpdBy;
	/**
     * 最近更新时间
     */
	@LastModifiedDate
	@Column(name="last_upd_time")
	private Date lastUpdTime;
	/**
     * 最少间隔
     */
	@Column(name="min_space")
	private int minSpace;
	/**
     * 月执行类型：第，在
     */
	@Column(name="month_type")
	private String monthType;
	/**
     * 计划名称
     */
	@Column(name="[name]")
	private String name;
	/**
     * 下次任务生成日期
     */
	@Temporal(TemporalType.DATE)
	@Column(name="next_gen_date")
	private Date nextGenDate;
	/**
     * 公司Id
     */
	@Column(name="org_code")
	private String orgCode;
	/**
     * 计划开始日期
     */
	@Temporal(TemporalType.DATE)
	@Column(name="plan_begin")
	private String planBegin;
	/**
     * 计划结束日期
     */
	@Temporal(TemporalType.DATE)
	@Column(name="plan_end")
	private String planEnd;
	/**
     * 计划类型：日，周，月，年
     */
	@Column(name="plan_type")
	private String planType;
	/**
     * 备注
     */
	private String remark;
	/**
     * 备注1
     */
	private String remark1;
	/**
     * 备注2
     */
	private String remark2;
	/**
     * 路线编号
     */
	@Column(name="route_id")
	private long routeId;
	/**
     * 评分计算公式
     */
	@Column(name="score_formula")
	private String scoreFormula;
	/**
     * 状态:0-已停用；1-正常
     */
	@Column(name="[status]")
	private byte status;
	/**
     * 用户编号
     */
	@Column(name="user_id")
	private String userId;
	/**
     * 开始编号
     */
	@Column(name="week_begin_num")
	private int weekBeginNum;
	/**
     * 周几
     */
	@Column(name="week_day")
	private int weekDay;
	/**
     * 结束编号
     */
	@Column(name="week_end_num")
	private int weekEndNum;
	/**
     * 哪一天
     */
	@Column(name="what_day")
	private String whatDay;
	/**
     * 第几周
     */
	@Column(name="what_week")
	private int whatWeek;

	/**
	 * 是否删除：0表示未删除，1表示已删除
	 */
	@Column(name="is_delete")
	private boolean isDelete=false;

	/**
	 * 原始字段
	 */
	@Column(name = "original_id", columnDefinition = "varchar(50) COMMENT '原始字段'")
	private String originalId;
	
	/**
     * 
     * 任务id
     */
	@Column(name="plan_task_id")
	private Long planTaskId = 0L;
	
	/**
	 * 是否单人执行
	 */
	@Column(name="is_single_execution")
	private boolean isSingleExecution=false;

	/**
	 * 用户部门
	 */
	@Column(name="user_dept")
	private String userDept;


	//单位code
	@Column(name = "biz_org_code")
	private String bizOrgCode;
	//单位名称
	@Column(name = "biz_org_name")
	private String bizOrgName;


	public String getBizOrgCode() {
		return bizOrgCode;
	}

	public void setBizOrgCode(String bizOrgCode) {
		this.bizOrgCode = bizOrgCode;
	}

	public String getBizOrgName() {
		return bizOrgName;
	}

	public void setBizOrgName(String bizOrgName) {
		this.bizOrgName = bizOrgName;
	}

	public String getUserDept() {
		return userDept;
	}

	public void setUserDept(String userDept) {
		this.userDept = userDept;
	}

	public Plan() {
	}

	public String getDeptId() {
		return deptId;
	}

	public void setDeptId(String deptId) {
		this.deptId = deptId;
	}
	
	public String getCreateBy() {
		return this.createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}


	public Time getDayBegin() {
		return this.dayBegin;
	}

	public void setDayBegin(Time dayBegin) {
		this.dayBegin = dayBegin;
	}

	public Time getDayEnd() {
		return this.dayEnd;
	}

	public void setDayEnd(Time dayEnd) {
		this.dayEnd = dayEnd;
	}

	public int getDayInterval() {
		return this.dayInterval;
	}

	public void setDayInterval(int dayInterval) {
		this.dayInterval = dayInterval;
	}

	public String getDayIntervalUnit() {
		return this.dayIntervalUnit;
	}

	public void setDayIntervalUnit(String dayIntervalUnit) {
		this.dayIntervalUnit = dayIntervalUnit;
	}

	public int getDayRate() {
		return this.dayRate;
	}

	public void setDayRate(int dayRate) {
		this.dayRate = dayRate;
	}

	public String getDayTime() {
		return this.dayTime;
	}

	public void setDayTime(String dayTime) {
		this.dayTime = dayTime;
	}

	public int getDuration() {
		return this.duration;
	}

	public void setDuration(int duration) {
		this.duration = duration;
	}

	public int getError() {
		return this.error;
	}

	public void setError(int error) {
		this.error = error;
	}

	public int getExecuteRate() {
		return this.executeRate;
	}

	public void setExecuteRate(int executeRate) {
		this.executeRate = executeRate;
	}

	public String getInOrder() {
		return this.inOrder;
	}

	public void setInOrder(String inOrder) {
		this.inOrder = inOrder;
	}	





	public String getIsFixedDate() {
		return this.isFixedDate;
	}

	public void setIsFixedDate(String isFixedDate) {
		this.isFixedDate = isFixedDate;
	}

	public String getIsScore() {
		return this.isScore;
	}

	public void setIsScore(String isScore) {
		this.isScore = isScore;
	}

	public String getLastUpdBy() {
		return this.lastUpdBy;
	}

	public void setLastUpdBy(String lastUpdBy) {
		this.lastUpdBy = lastUpdBy;
	}

	public Date getLastUpdTime() {
		return this.lastUpdTime;
	}

	public void setLastUpdTime(Date lastUpdTime) {
		this.lastUpdTime = lastUpdTime;
	}

	public int getMinSpace() {
		return this.minSpace;
	}

	public void setMinSpace(int minSpace) {
		this.minSpace = minSpace;
	}

	public String getMonthType() {
		return this.monthType;
	}

	public void setMonthType(String monthType) {
		this.monthType = monthType;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Date getNextGenDate() {
		return this.nextGenDate;
	}

	public void setNextGenDate(Date nextGenDate) {
		this.nextGenDate = nextGenDate;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getPlanBegin() {
		return this.planBegin;
	}

	public void setPlanBegin(String planBegin) {
		this.planBegin = planBegin;
	}

	public String getPlanEnd() {
		return this.planEnd;
	}

	public void setPlanEnd(String planEnd) {
		this.planEnd = planEnd;
	}

	public String getPlanType() {
		return this.planType;
	}

	public void setPlanType(String planType) {
		this.planType = planType;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public long getRouteId() {
		return this.routeId;
	}

	public void setRouteId(long routeId) {
		this.routeId = routeId;
	}

	public String getScoreFormula() {
		return this.scoreFormula;
	}

	public void setScoreFormula(String scoreFormula) {
		this.scoreFormula = scoreFormula;
	}

	public byte getStatus() {
		return this.status;
	}

	public void setStatus(byte status) {
		this.status = status;
	}

	public String getUserId() {
		return this.userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public int getWeekBeginNum() {
		return this.weekBeginNum;
	}

	public void setWeekBeginNum(int weekBeginNum) {
		this.weekBeginNum = weekBeginNum;
	}

	public int getWeekDay() {
		return this.weekDay;
	}

	public void setWeekDay(int weekDay) {
		this.weekDay = weekDay;
	}

	public int getWeekEndNum() {
		return this.weekEndNum;
	}

	public void setWeekEndNum(int weekEndNum) {
		this.weekEndNum = weekEndNum;
	}

	public String getWhatDay() {
		return this.whatDay;
	}

	public void setWhatDay(String whatDay) {
		this.whatDay = whatDay;
	}

	public int getWhatWeek() {
		return this.whatWeek;
	}

	public void setWhatWeek(int whatWeek) {
		this.whatWeek = whatWeek;
	}
	public String getRemark1() {
		return remark1;
	}

	public void setRemark1(String remark1) {
		this.remark1 = remark1;
	}

	public String getRemark2() {
		return remark2;
	}

	public void setRemark2(String remark2) {
		this.remark2 = remark2;
	}

	public int getExecuteInterval() {
		return executeInterval;
	}

	public void setExecuteInterval(int executeInterval) {
		this.executeInterval = executeInterval;
	}

	public int getFirstFlag() {
		return firstFlag;
	}

	public void setFirstFlag(int firstFlag) {
		this.firstFlag = firstFlag;
	}

	public boolean getIsDelete() {
		return isDelete;
	}

	public void setIsDelete(boolean isDelete) {
		this.isDelete = isDelete;
	}

	public String getOriginalId() {
		return originalId;
	}

	public void setOriginalId(String originalId) {
		this.originalId = originalId;
	}
	
	public Long getPlanTaskId() {
		return planTaskId;
	}

	public void setPlanTaskId(Long planTaskId) {
		this.planTaskId = planTaskId;
	}

	public boolean getIsSingleExecution() {
		return isSingleExecution;
	}

	public void setIsSingleExecution(boolean isSingleExecution) {
		this.isSingleExecution = isSingleExecution;
	}
}