package com.yeejoin.equipmanage.mapper;

import org.apache.ibatis.annotations.Param;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;
import java.util.Map;

/**
 *  Mapper 接口
 *
 */
public interface EmergencyMapper extends BaseMapper{

    /**
     * 应急物资列表
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> selectEmergencyMaterials();

    /**
     * 应急物资详情
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectEmergencyMaterialsDetails(Page<Map<String, Object>> page, @Param("bizOrgCode") String bizOrgCode);

    /**
     * 消防炮列表
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectFireMonitor(Page<Map<String, Object>> page, @Param("bizOrgCode") String bizOrgCode, @Param("code") String code);

    /**
     * 泡沫罐
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectFoamTank(Page<Map<String, Object>> page);

    /**
     * 排油系统
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectOilDrainage(Page<Map<String, Object>> page , @Param("bizOrgCode") String bizOrgCode, @Param("code") String code);

    /**
     * 压力流量
     * @param page
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectPressureFlow(Page<Map<String, Object>> page , @Param("bizOrgCode") String bizOrgCode);


    List<Map<String, Object>> getSystemState(@Param("bizOrgCode") String bizOrgCode);

    List<Map<String, Object>> getCAFSWaterTankInfo();

    List<Map<String, Object>> selectAlarmAnalysis(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("dataType")String dataType, @Param("date")String date, @Param("list") List<String> codes);

    List<Map<String, Object>> selectAlarmAnalysisCount( @Param("startDate")String startDate, @Param("endDate")String endDate,@Param("list") List<String> codes);

    Map<String, Object> getSystemAndCarCount();

    List<String> selectSystemCodes(@Param("systemType") String systemType);

    List<Map<String, Object>> selectFireCannonAlarmAnalysisPie(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("list") List<String> codes);

    List<Map<String, Object>> waterSystemAlarmAnalysisPie(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("list") List<String> codes);

    List<Map<String, Object>> waterSystemAlarmAnalysis(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("dataType")String dataType, @Param("date")String date, @Param("list") List<String> codes);

    List<Map<String, Object>> fireCannonSystemAlarmAnalysis(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("dataType")String dataType, @Param("date")String date, @Param("list") List<String> codes);

    List<Map<String, String>> getEquipExpiryList(@Param("expiryDayNum") Integer expiryDayNum);

    Map<String, Integer> getStockEquipStatistics();

    List<Map<String, Object>> getEquipExpiryStatistics(@Param("expiryDayNum") Integer expiryDayNum);

}
