package com.yeejoin.amos.boot.module.common.api.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
* 联动单位
*
* @author system_generator
* @date 2021-07-16
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_linkage_unit")
public class LinkageUnit extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单位名称
     */
	@TableField("unit_name")
    private String unitName;

    /**
     * 单位code
     */
	@TableField("unit_code")
    private String unitCode;

    /**
     * 父级单位id
     */
	@TableField("parent_id")
    private String parentId;

    /**
     * 联动单位类别
     */
	@TableField("linkage_unit_type")
    private String linkageUnitType;

    /**
     * 联动单位类别code
     */
	@TableField("linkage_unit_type_code")
    private String linkageUnitTypeCode;

    /**
     * 行政区划
     */
	@TableField("administrative_divisions")
    private String administrativeDivisions;

    /**
     * 行政区划代码
     */
	@TableField("administrative_divisions_code")
    private String administrativeDivisionsCode;

    /**
     * 地址
     */
	@TableField("address")
    private String address;

    /**
     * 经度
     */
	@TableField("longitude")
    private Double longitude;

    /**
     * 纬度
     */
	@TableField("latitude")
    private Double latitude;

    /**
     * 协议开始日期
     */
	@TableField("agreement_start_date")
    private Date agreementStartDate;

    /**
     * 协议结束日期
     */
	@TableField("agreement_end_date")
    private Date agreementEndDate;

    /**
     * 应急联动单位类别
     */
	@TableField("emergency_linkage_unit")
    private String emergencyLinkageUnit;

    /**
     * 应急联动单位类别code
     */
	@TableField("emergency_linkage_unit_code")
    private String emergencyLinkageUnitCode;

    /**
     * 联系人 
     */
	@TableField("contact_user")
    private String contactUser;

    /**
     * 联系人电话
     */
	@TableField("contact_phone")
    private String contactPhone;

    /**
     * 实例id
     */
	@TableField("instance_id")
    private Long instanceId;

    /**
     * 组织机构代码
     */
	@TableField("org_code")
    private String orgCode;

    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

}
