package com.yeejoin.equipmanage.common.utils;

public class CoordinateUtil {
	// WGS84标准参考椭球中的地球长半径(单位:千米)
	private static final double EARH_RADIUS_WGS84 = 6378137.0/1000;

	public static double distance(double lat1, double lng1, double lat2, double lng2) {
		double radLat1 = Math.toRadians(lat1);
		double radLat2 = Math.toRadians(lat2);

		double a = radLat1 - radLat2;
		double b = Math.toRadians(lng1) - Math.toRadians(lng2);

		double s = 2 * Math.asin(Math.sqrt(
				Math.pow(Math.sin(a / 2), 2) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2), 2)));
		return Math.round(s * EARH_RADIUS_WGS84);
	}
}
