package com.yeejoin.precontrol.common.dto;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

import java.util.Date;

@Data
public class CompanyImportDto  extends BaseDto {

    private Long id;
    @Excel(name = "企业名称")
    private String name;
    @Excel(name = "联系人")
    private String contact;
    @Excel(name = "手机号码")
    private String phone;
    @Excel(name = "固定电话")
    private String tel;
    @Excel(name = "客服电话")
    private String servicePhone;
    @Excel(name = "网址")
    private String website;
    @Excel(name = "邮箱")
    private String email;
    @Excel(name = "企业类型", replace = {"分包商 _0", "非分包商_1", "_null"})
    private String typeKey;
    private String region;
    @Excel(name = "企业地址")
    private String regionName;
    @Excel(name = "企业简介")
    private String introduction;
    @Excel(name = "综合评分")
    private Float compositeScore;
    @Excel(name = "统一社会信用代码")
    private String creditCode;
    @Excel(name = "编号")
    private String code;
    @Excel(name = "工商类型")
    private String type;
    @Excel(name = "法定代表人")
    private String legalRepresentative;
    @Excel(name = "注册资本")
    private Integer registerCapital;
    @Excel(name = "注册资本单位", replace = {"人民币_0", "美元_1", "_null"})
    private String registerCapitalUnitKey;
    @Excel(name = "成立日期", importFormat = "yyyy-MM-dd")
    private Date establishDate;
    @Excel(name = "营业期限是否永久", replace = {"否_0", "是_1"})
    private Integer permanent;
    @Excel(name = "营业开始时间", importFormat = "yyyy-MM-dd")
    private Date businessStartDate;
    @Excel(name = "营业结束时间", importFormat = "yyyy-MM-dd")
    private Date businessEndDate;
    @Excel(name = "发证日期", importFormat = "yyyy-MM-dd")
    private Date athDate;
    @Excel(name = "登记机关")
    private String registerAuthority;
    @Excel(name = "住所")
    private String companyAddress;
    @Excel(name = "经营范围")
    private String businessScope;
    @Excel(name = "证书名称")
    private String certificateName;
    @Excel(name = "证书编号")
    private String certificateNumber;
    @Excel(name = "有效期至", importFormat = "yyyy-MM-dd")
    private Date expireToDate;
    @Excel(name = "发证机关")
    private String issuingAuthority;
    private Date createDate;

}
