package com.yeejoin.amos.patrol.business.dao.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.patrol.dao.entity.RoutePointItem;

public interface IRoutePointItemDao extends BaseDao<RoutePointItem, Long> {

	@Modifying
	@Transactional
	@Query(value = "delete from p_route_point_item WHERE route_point_id = ?1", nativeQuery = true)
	void delRoutePointItem(Long routePointId);

	@Modifying
	@Transactional
	@Query(value = "DELETE FROM p_route_point_item WHERE point_input_item_id IN (?1)", nativeQuery = true)
	void delRoutePointItemByItemId(List<Long> pItemIds);

	@Modifying
	@Transactional
	@Query(value = "DELETE FROM p_route_point_item WHERE point_classify_id = ?1", nativeQuery = true)
	void delRoutePointItemByPointClassifyId(Long pItemIds);

	@Modifying
	@Query(value = "SELECT prpi.* FROM p_route_point_item prpi LEFT JOIN p_route_point prp ON prp.id = prpi.route_point_id WHERE prp.point_id = ?1 AND prpi.point_classify_id in (?2)", nativeQuery = true)
	List<RoutePointItem> getRoutePointItemByPointIdAndClassifyIds(Long pointId,List<Long> classifyIds);

	List<RoutePointItem> findAllByPointInputItemId(Long pointInputItemId);

	List<RoutePointItem> findAllByRoutePointId(Long routePointId);

	@Modifying
	@Query(value = "SELECT rpi.*,rp.point_id FROM `p_route_point_item` rpi LEFT JOIN p_route_point rp ON rp.id = rpi.route_point_id WHERE rp.route_id = ?1 AND rp.point_id in (?2)", nativeQuery = true)
	List<RoutePointItem> getRoutePointItemByRouteIdAndPointIds(Long pointId,List<Long> pointIds);

	@Modifying
	@Transactional
	@Query(value = "delete from p_route_point_item WHERE point_classify_id = ?1", nativeQuery = true)
	void delPointInputItemId(Long pointClassifyId);

	@Modifying
	@Query(value = "SELECT  * from p_route_point_item WHERE route_point_id = ?1 AND point_classify_id =?2", nativeQuery = true)
	List<RoutePointItem> getRoutePointItemList(Long pointId,Long pointClassifyId);



	@Modifying
	@Query(value = "SELECT prpi.* FROM p_route_point_item prpi LEFT JOIN p_route_point prp ON prp.id = prpi.route_point_id WHERE prp.point_id = ?1", nativeQuery = true)
	List<RoutePointItem> getRoutePointItemByPointId(Long pointId);

	@Modifying
	@Transactional
	@Query(value = "SELECT point_input_item_id from p_route_point_item WHERE route_point_id in (?1)", nativeQuery = true)
	List<String> selectByroutePointIds(List<String> routePointIds);
}
