package com.yeejoin.amos.supervision.core.framework;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.supervision.business.feign.JCSFeignClient;
import com.yeejoin.amos.supervision.exception.PermissionException;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
@Aspect
@Component
@ResponseBody
@Order(value = 1)
public class PersonIdentifyAspect {

    @Autowired
    RedisUtils redisUtils;
    @Autowired
    JCSFeignClient jcsFeignClient;
    @Value("${logic}")
    Boolean logic;

    @Before(value = "@annotation(com.yeejoin.amos.supervision.core.framework.PersonIdentify) && @annotation(permission)")
    public void personIdentity(JoinPoint joinPoint, PersonIdentify permission) throws PermissionException {
        ReginParams reginParam = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (permission.isNeedIdentity() && reginParam != null) {
            //调用jcs，进行人员身份判断，是维保公司人员还是业主单位人员
            String userId = reginParam.getUserModel().getUserId();
            FeignClientResult responseModel = jcsFeignClient.getUserUnit(userId);
            if (ObjectUtils.isEmpty(responseModel.getResult()) || responseModel.getStatus() != HttpStatus.OK.value()) {
                throw new RuntimeException(responseModel.getDevMessage());
            }
            List result = (List) responseModel.getResult();
            ReginParams.PersonIdentity personIdentity = new ReginParams.PersonIdentity();
            if (!ObjectUtils.isEmpty(result)) {
                Map map = (Map) result.get(0);
                Map other = (Map) map.get("DEPARTMENT");
                Map person = (Map) map.get("PERSON");
                if (!ObjectUtils.isEmpty(person)) {
                    personIdentity.setPersonSeq((String) person.get("sequenceNbr"));
                    personIdentity.setPersonName((String) person.get("bizOrgName"));
                }
                if (!ObjectUtils.isEmpty(other)) {
                    personIdentity.setCompanyId((String) other.get("sequenceNbr"));
                    personIdentity.setCompanyName((String) other.get("bizOrgName"));
                }
                //电力默认走公司权限
                if (!logic){
                    personIdentity.setBizOrgCode(StringUtils.isEmpty(personIdentity.getCompanyBizOrgCode()) ? "-1" : personIdentity.getCompanyBizOrgCode());
                }

//                ReginParams.PersonIdentity personIdentity = (ReginParams.PersonIdentity) Bean.mapToBean((Map<String, Object>) result.get(0), ReginParams.PersonIdentity.class);
                reginParam.setPersonIdentity(personIdentity);
                redisUtils.set(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken()), JSONObject.toJSONString(reginParam));
            } else {
                throw new RuntimeException("人员未绑定！");
            }
        }
    }

}
