package com.yeejoin.amos.boot.module.tdc.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.module.tdc.api.entity.TdcDrawing;
import com.yeejoin.amos.boot.module.tdc.api.mapper.TdcDrawingMapper;
import com.yeejoin.amos.boot.module.tdc.api.service.ITdcDrawingService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 服务实现类
 *
 * @author duanwei
 * @date 2022-11-22
 */
@Service
public class TdcDrawingServiceImpl extends ServiceImpl<TdcDrawingMapper, TdcDrawing> implements ITdcDrawingService {


    public List<TdcDrawing> saveAttachment(@RequestBody JSONObject attachment, AgencyUserModel userInfo) {
        List<TdcDrawing> tdcDrawingList = new ArrayList<>();

        if (!ValidationUtil.isEmpty(attachment)) {
            JSONArray attachment1 = attachment.getJSONArray("attachment");
            for (Object i : attachment1) {
                TdcDrawing tdcDrawing = new TdcDrawing();
                List<CompanyModel> company = userInfo.getCompanys();
                if (!CollectionUtils.isEmpty(company)) {
                    //机构名称
                    String companyName = company.get(0).getCompanyName();
                    tdcDrawing.setUploadCompanyName(companyName);
                    //机构code
                    String orgCode = company.get(0).getOrgCode();
                    tdcDrawing.setUploadCompanyCode(orgCode);
                    //登录人姓名
                    String realName = userInfo.getRealName();
                    tdcDrawing.setUploadUserName(realName);
                }
                JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(i));
                tdcDrawing.setDrawingName(jsonObject.getString("name"));
                tdcDrawing.setDrawingUrl(jsonObject.getString("url"));
                tdcDrawing.setUploadTime(new Date());

                save(tdcDrawing);
                tdcDrawingList.add(tdcDrawing);
            }

        }

        return tdcDrawingList;
    }

}
