package com.yeejoin.amos.api.openapi.face.orm.entity;

import java.io.Serializable;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 人员数据信息-资质信息
 *
 * @author duanwei
 * @date 2022-07-20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("tm_jg_staff_qualif_info")
@ApiModel(value="TmJgStaffQualifInfo对象", description="人员数据信息-资质信息")
public class StaffQualifInfo extends AbstractBaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "作业人员身份证号")

    private String operatorId;

    @ApiModelProperty(value = "作业项目名称")
    private String operationItem;

    @ApiModelProperty(value = "作业项目代号")
    private String operationItemCode;

    @ApiModelProperty(value = "有效日期")
    private Date effectiveDate;

    @ApiModelProperty(value = "发证机关")
    private String issuingAuthor;


}
