package com.yeejoin.amos.boot.module.jxiop.api.entity;

import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 户用光伏表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "household_pv", autoResultMap = true)
public class HouseholdPv extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 户主姓名
	 */
	@TableField("name")
	private String name;

	/**
	 * 户号
	 */
	@TableField("number")
	private String number;

	/**
	 * 厂商
	 */
	@TableField("platform_company_id")
	private Long platformCompanyId;

	/**
	 * 性别
	 */
	@TableField("sex")
	private String sex;

	/**
	 * 身份证号
	 */
	@TableField("ID_number")
	private String idNumber;

	/**
	 * 证件过期时间
	 */
	@TableField("expiry_time")
	private Date expiryTime;

	/**
	 * 签发机关
	 */
	@TableField("issuing_authority")
	private String issuingAuthority;

	/**
	 * 户籍地址
	 */
	@TableField("residence_address")
	private String residenceAddress;

	/**
	 * 手机号码
	 */
	@TableField("phone")
	private String phone;

	/**
	 * 居住地
	 */
	@TableField("address")
	private String address;

	/**
	 * 邮编
	 */
	@TableField("postcode")
	private String postcode;

	/**
	 * 身份证正面
	 */
	@TableField(value = "ID_front_photo", typeHandler = FastjsonTypeHandler.class)
	private List<CommonFile> idFrontPhoto;

	/**
	 * 身份证背面
	 */
	@TableField(value = "ID_back_photo", typeHandler = FastjsonTypeHandler.class)
	private List<CommonFile> idBackPhoto;

	/**
	 * 房屋产权证
	 */
	@TableField(value = "house_property_certificate", typeHandler = FastjsonTypeHandler.class)
	private List<CommonFile> housePropertyCertificate;

	/**
	 * 农户首页照片
	 */
	@TableField(value = "homepage_photo", typeHandler = FastjsonTypeHandler.class)
	private List<CommonFile> homepagePhoto;

	/**
	 * 送达地址
	 */
	@TableField("service_address")
	private String serviceAddress;

	/**
	 * 组织机构code
	 */
	@TableField("biz_org_code")
	private String bizOrgCode;

	/**
	 * 告警等级
	 */
	@TableField("level")
	private String level;

	/**
	 * 区域id
	 */
	@TableField("district_id")
	private Long districtId;

	/**
	 * 创建时间
	 */
	@TableField("create_time")
	private Date createTime;

}
