package com.yeejoin.precontrol.controller;

import java.util.Arrays;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.KnowledgeShareDto;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.Task;
import com.yeejoin.precontrol.common.service.ITaskKnowledgeShareService;
import com.yeejoin.precontrol.common.utils.NameUtils;
import com.yeejoin.precontrol.controller.publics.BaseController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 知识分享任务表
 *
 * @author wujiang
 * @date 2020-12-21
 */
@RestController
@Api(tags = "知识分享任务表Api")
@RequestMapping(value = "/task-knowledge-share", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TaskKnowledgeShareController extends BaseController {

	@Autowired
	ITaskKnowledgeShareService iTaskKnowledgeShareService;

	/**
	 * 新增知识分享
	 * 
	 * @return
	 * 
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增知识分享", notes = "新增知识分享")
	public boolean save(HttpServletRequest request, @RequestBody KnowledgeShareDto knowledgeShareDto) {
		Person peron = getPerson();
		knowledgeShareDto.setCreatePersonId(peron.getId());
		knowledgeShareDto.setOrgCode(peron.getOrgCode());
		knowledgeShareDto = iTaskKnowledgeShareService.saveOne(knowledgeShareDto);
		iTaskKnowledgeShareService.knowledgeNotice(knowledgeShareDto); // 发送知识推送消息
		return true;
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iTaskKnowledgeShareService.removeById(id);
	}

	/**
	 * 修改知识分享
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改知识分享", notes = "修改知识分享")
	public boolean updateByIdTaskPersonFeedback(HttpServletRequest request,
			@RequestBody KnowledgeShareDto knowledgeShareDto) {
		return iTaskKnowledgeShareService.updateOneById(knowledgeShareDto);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public KnowledgeShareDto selectById(HttpServletRequest request, @PathVariable Long id) {
		Person person = getPerson();
		return iTaskKnowledgeShareService.queryById(person.getId(), id);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<Task> listPage(String pageNum, String pageSize, KnowledgeShareDto knowledgeShareDto) {

		Page<Task> pageBean;
		QueryWrapper<Task> knowledgeShareQueryWrapper = new QueryWrapper<>();
		Class<? extends KnowledgeShareDto> aClass = knowledgeShareDto.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(knowledgeShareDto);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(knowledgeShareDto);
						knowledgeShareQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(knowledgeShareDto);
						knowledgeShareQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(knowledgeShareDto);
						knowledgeShareQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(knowledgeShareDto);
						knowledgeShareQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<Task> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iTaskKnowledgeShareService.page(pageBean, knowledgeShareQueryWrapper);
		return page;
	}
}
