package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectInitiationServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ResponseHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@Api(tags = "流程相关")
@RequestMapping(value = "/projectInitiation")
public class ProjectInitiationController {

    @Autowired
    ProjectInitiationServiceImpl projectInitiationServiceImpl;

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/start")
    @ApiOperation(httpMethod = "GET", value = "流程启动", notes = "流程启动")
    public ResponseModel<String> start() throws Exception {
        return ResponseHelper.buildResponse(projectInitiationServiceImpl.startTest());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/execute/{instanceId}")
    @ApiOperation(httpMethod = "GET", value = "流程启动", notes = "流程启动")
    public ResponseModel<String> execute(@PathVariable("instanceId")String instanceId, String condition,String option) throws Exception {
        return ResponseHelper.buildResponse( projectInitiationServiceImpl.executeTest(instanceId,condition,option));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/getTaskList/{instanceId}")
    @ApiOperation(httpMethod = "GET", value = "流程启动", notes = "流程启动")
    public ResponseModel<String> getTaskList(@PathVariable("instanceId")String instanceId) throws Exception {
        projectInitiationServiceImpl.getTaskList(instanceId);
        return ResponseHelper.buildResponse("");
    }
}
