package com.yeejoin.amos.boot.module.tzs.flc.api.feign;



import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@FeignClient(value = "AMOS-API-PRIVILEGE",configuration = {FeignConfiguration.class})
public interface PrivilegeFeginService {

    @RequestMapping(value = "/privilege/v1/agencyuser/me", method = RequestMethod.GET)
    ResponseModel<AgencyUserModel> getMe();

    //获取单位树
    @RequestMapping(value = "/privilege/v1/company/tree", method = RequestMethod.GET)
    FeignClientResult tree();

    //获取省级行政区划
    @RequestMapping(value = "systemctl/v1/region/level", method = RequestMethod.GET)
    FeignClientResult getProvince(@RequestParam String level);

    //获取行政区划树
    @RequestMapping(value = "systemctl/v1/region/tree", method = RequestMethod.GET)
    FeignClientResult getTree();
}
