package com.yeejoin.amos.boot.module.ugp.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.module.ugp.api.entity.Company;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.Weld;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 项目信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="ProjectDto", description="项目信息表")
public class ProjectDto  extends BaseDto {

   private static final long serialVersionUID = 1L;

    Project project;

    @ApiModelProperty(value = "项目名称")
    private String name;

    @ApiModelProperty(value = "项目编号")
    private String code;

    @ApiModelProperty(value = "项目进度")
    private String progressStatus;

    @ApiModelProperty(value = "项目地点")
    private String address;

    @ApiModelProperty(value = "项目开工日期")
    private Date startDate;

    @ApiModelProperty(value = "项目安装区域代码")
    private String installRegionCode;

    @ApiModelProperty(value = "项目安装区域")
    private String installRegion;

    @ApiModelProperty(value = "建设单位id")
    private Long constructionUnitId;

    @ApiModelProperty(value = "建设单位名称")
    private String constructionUnit;

    @ApiModelProperty(value = "项目设计单位")
    private String designUnit;

    @ApiModelProperty(value = "项目设计单位id")
    private Long designUnitId;

    @ApiModelProperty(value = "安装单位id")
    private Long installationUnitId;

    @ApiModelProperty(value = "安装单位名称")
    private String installationUnit;

    @ApiModelProperty(value = "企业id")
    private Long companyId;

    @ApiModelProperty(value = "建设单位负责人id")
    private Long chargePersonId;

    @ApiModelProperty(value = "建设单位负责人名称")
    private String chargePerson;

    @ApiModelProperty(value = "组织机构代码")
    private String orgCode;

    @ApiModelProperty(value = "项目提交日期")
    private Date submitDate;

    @ApiModelProperty(value = "流程id")
    private String instanceId;

    @ApiModelProperty(value = "流程状态")
    private String status;

    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 安装单位联系人id
     */
    private Long installUnitChargerId;

    /**
     * 安装单位联系人
     */
    private String installUnitCharger;

    /**
     * 无损检测单位id
     */
    private Long testingUnitId;

    /**
     * 无损检测单位
     */
    private String testingUnit;

    /**
     * 监理单位id
     */
    private Long supervisionUnitId;

    /**
     * 监理单位
     */
    private String supervisionUnit;

    /**
     * 设计压力
     */
    private String designPressure;

    /**
     * 输送介质
     */
    private String conveyingMedium;

    /**
     * 工程规模
     */
    private String projectScale;

    /**
     * 竣工预计日期
     */
    private Date completionEstimate;

    /**
     * 压力管道级别
     */
    private String pressureLevel;


    private List<PipeDto> pipeSubForm;

    /**
     * 监检部门
     */
    private String inspectionUnit;
    /**
     * 监察部门
     */
    private String superviseDept;

    private JSONArray installSubForm;

    private JSONArray designSubForm;

    private String examineProjectState;

    private String processProjectState;

    private String insDepId;
    private String insDep;
    private String insPerson;
    private String startDateString;

    private String companyType;

    private String length;

    /**
     *经度
     */
    @TableField("longitude")
    private String longitude;

    /**
     *纬度
     */
    @TableField("latitude")
    private String latitude;

    private List<String> userId;
    private String  context;

    List<Weld> weldList;
    List<List<Double>> weldLines;

    /**
    * 组织机构代码
    */
    private String creditCode;

    private String completionEstimateString;

    private String constructionLicenseCode;

    private String designLicenseCode;

    private String installationLicenseCode;

    private String supervisionLicenseCode;

    private String testingLicenseCode;
}
