package com.yeejoin.amos.dockingData;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.scenario.effect.impl.sw.sse.SSEBlend_SRC_OUTPeer;
import com.yeejoin.amos.api.householdapi.Utils.HouseholdPvUtils;
import com.yeejoin.amos.component.influxdb.InfluxDbConnection;
import org.jetbrains.annotations.TestOnly;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.influx.InfluxDbHealthIndicator;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.zip.Inflater;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/6/16
 */
@Component
public class DockingData {


    @Autowired
    InfluxDbConnection influxDbConnection;
    @Autowired
    HouseholdPvUtils householdPvUtils;
    //初始化执行
   @PostConstruct
   public void init(){
    this.getDate();
   }


    //每二十分钟执行一次
    @Scheduled(cron = "0 0/20 * * * ?")
    public void fixedRate() {
        this.getDate();
  }

    //请求获取数据
   public void getDate(){


       //首航
       String data1=householdPvUtils.gerResponseByAPiID(1000000002L);
       JSONObject json= JSON.parseObject(data1);

       if((Boolean)json.get("success")){
           JSONArray obj= json.get("stationList") !=null?(JSONArray)json.get("stationList"):null;
           if (obj!=null) {
               for (Object o : obj) {
                   Map<String,Object> maps1 = (Map<String,Object>)o;
                   Map<String,String> maps2=new HashMap<>();
                   maps2.put("key", UUID.randomUUID().toString());
                   influxDbConnection.insert("SH_DZ",maps2,maps1);
               }
           }
       }

       String data2=householdPvUtils.gerResponseByAPiID(1000000003L);
       JSONObject json2= JSON.parseObject(data2);
       if((Boolean)json2.get("success")) {
           JSONArray obj2 = json.get("deviceList") != null ? (JSONArray) json2.get("deviceList") : null;
           if (obj2!=null) {
               for (Object o : obj2) {
                   Map<String, Object> maps1 = (Map<String, Object>) o;
                   Map<String, String> maps2 = new HashMap<>();
                   maps2.put("key", UUID.randomUUID().toString());
                   influxDbConnection.insert("SH_ZB", maps2, maps1);
               }
           }
       }

           //固德威
           String data3 = householdPvUtils.gerResponseByAPiID(1000000006L);

       JSONObject json3= JSON.parseObject(data3);
       if(Integer.valueOf(json3.get("code").toString())==0) {
           JSONObject obj3 = json3.get("data") != null ? (JSONObject)json3.get("data") : null;
           if (obj3!=null&&obj3.get("list")!=null) {

               JSONArray ob =  obj3.get("list") != null ? (JSONArray)  obj3.get("list") : null;

               for (Object o : ob) {
                   Map<String, Object> maps1 = (Map<String, Object>) o;
                   Map<String, String> maps2 = new HashMap<>();
                   maps2.put("key", UUID.randomUUID().toString());
                   influxDbConnection.insert("GD_DZ", maps2, maps1);
               }
           }
       }
       
           String data4 = householdPvUtils.gerResponseByAPiID(1000000007L);

       JSONObject json4= JSON.parseObject(data4);
       if(Integer.valueOf(json4.get("code").toString())==0) {
           JSONObject obj4 = json4.get("data") != null ? (JSONObject)json4.get("data") : null;
           if (obj4!=null&&obj4.get("list")!=null) {

               JSONArray ob =  obj4.get("list") != null ? (JSONArray)  obj4.get("list") : null;

               for (Object o : ob) {
                   Map<String, Object> maps1 = (Map<String, Object>) o;
                   Map<String, String> maps2 = new HashMap<>();
                   maps2.put("key", UUID.randomUUID().toString());
                   influxDbConnection.insert("GD_ZT", maps2, maps1);
               }
           }
       }

           String data5 = householdPvUtils.gerResponseByAPiID(1000000008L);

       JSONObject json5= JSON.parseObject(data5);
       if(Integer.valueOf(json5.get("code").toString())==0) {
           JSONObject obj5 = json5.get("data") != null ? (JSONObject)json5.get("data") : null;
           if (obj5!=null&&obj5.get("list")!=null) {

               JSONArray ob =  obj5.get("list") != null ? (JSONArray)  obj5.get("list") : null;

               for (Object o : ob) {
                   Map<String, Object> maps1 = (Map<String, Object>) o;
                   Map<String, String> maps2 = new HashMap<>();
                   maps2.put("key", UUID.randomUUID().toString());
                   influxDbConnection.insert("GD_GJ", maps2, maps1);
               }
           }
       }


       String data6 = householdPvUtils.gerResponseByAPiID(1686897906789L);

       JSONObject json6= JSON.parseObject(data6);
       if(Integer.valueOf(json6.get("code").toString())==0) {
           JSONObject obj6 = json6.get("data") != null ? (JSONObject)json6.get("data") : null;
           if (obj6!=null&&obj6.get("page")!=null) {

               JSONArray ob = ((JSONObject)obj6.get("page")).get("records")!= null ? (JSONArray)  ((JSONObject)obj6.get("page")).get("records") : null;

               for (Object o : ob) {
                   Map<String, Object> maps1 = (Map<String, Object>) o;
                   Map<String, String> maps2 = new HashMap<>();
                   maps2.put("key", UUID.randomUUID().toString());
                   influxDbConnection.insert("JL_CZ", maps2, maps1);
               }
           }
       }
    String data7 = householdPvUtils.gerResponseByAPiID(1686900771946L);
       JSONObject json7= JSON.parseObject(data7);
       if(Integer.valueOf(json7.get("code").toString())==0) {
           JSONObject obj7 = json7.get("data") != null ? (JSONObject)json7.get("data") : null;
           if (obj7!=null&&obj7.get("page")!=null) {

               JSONArray ob = ((JSONObject)obj7.get("page")).get("records")!= null ? (JSONArray)  ((JSONObject)obj7.get("page")).get("records") : null;

               for (Object o : ob) {
                   Map<String, Object> maps1 = (Map<String, Object>) o;
                   Map<String, String> maps2 = new HashMap<>();
                   maps2.put("key", UUID.randomUUID().toString());

                   maps1.put("etotal1",maps1.get("etotal1").toString());
                   maps1.put("etoday1",maps1.get("etoday1").toString());
                   influxDbConnection.insert("JL_NBQ", maps2, maps1);
               }
           }
       }
       String data8 = householdPvUtils.gerResponseByAPiID(1686900972965L);
       JSONObject json8= JSON.parseObject(data8);
       if(Integer.valueOf(json8.get("code").toString())==0) {
           JSONObject obj8 = json8.get("data") != null ? (JSONObject)json8.get("data") : null;
           if (obj8!=null&&obj8.get("records")!=null) {

               JSONArray ob = obj8.get("records")!= null ? (JSONArray)obj8.get("records")   : null;

               for (Object o : ob) {
                   Map<String, Object> maps1 = (Map<String, Object>) o;
                   Map<String, String> maps2 = new HashMap<>();
                   maps2.put("key", UUID.randomUUID().toString());
                   influxDbConnection.insert("JL_GJ", maps2, maps1);
               }
           }
       }
   }



}
