package com.yeejoin.amos.boot.module.jxiop.api.dto;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jxiop.api.entity.CameraInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.Date;

/**
 * 地图片区
 *
 * @author system_generator
 * @date 2023-06-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "MapRegionDto", description = "地图片区")
public class MapRegionDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "片区名称")
    private String name;

    @ApiModelProperty(value = "省份，中间用英文逗号隔开")
    private ArrayList<String> province;

    @ApiModelProperty(value = "片区文字显示的省份")
    private String modelName;

    @ApiModelProperty(value = "偏移量")
    private ArrayList<Integer> titlePos;

    @ApiModelProperty(value = "片区中心点")
    private CameraInfo cameraInfo;
}
