package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.hygf.api.dto.*;
import com.yeejoin.amos.boot.module.hygf.api.entity.*;
import com.yeejoin.amos.boot.module.hygf.api.mapper.SurveyInformationMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.ISurveyInformationService;
import com.yeejoin.amos.boot.module.hygf.api.util.BeanDtoUtils;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 勘察信息服务实现类
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Service
public class SurveyInformationServiceImpl extends BaseService<SurveyInformationDto,SurveyInformation,SurveyInformationMapper> implements ISurveyInformationService {


    @Autowired
    SurveyDetailsServiceImpl surveyDetailsService;

    @Autowired
    InformationServiceImpl informationService;

    @Autowired
    ExtendedInformationServiceImpl extendedInformationService;

    @Autowired
    CommercialServiceImpl commercialService;

    @Autowired
    PeasantHouseholdServiceImpl peasantHouseholdServiceImpl;

    @Autowired
    RedisUtils redisUtils;

    private static final String regionRedis="app_region_redis";


    /**
     * 分页查询
     */
    public Page<SurveyInformationDto> queryForSurveyInformationPage(Page<SurveyInformationDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<SurveyInformationDto> queryForSurveyInformationList()   {
        return this.queryForList("" , false);
    }


    public SurveyInfoAllDto saveSurveyInfo(SurveyInfoAllDto surveyInfoAllDto)   {

        SurveyInformation surveyInformation = BeanDtoUtils.convert(surveyInfoAllDto.getSurveyInformation(), SurveyInformation.class);
        this.saveOrUpdate(surveyInformation);

        SurveyDetails surveyDetails = BeanDtoUtils.convert(surveyInfoAllDto.getSurveyDetails(), SurveyDetails.class);
        surveyDetailsService.save(surveyDetails.setSurveyInformationId(surveyInformation.getSequenceNbr()));

        Information information = BeanDtoUtils.convert(surveyInfoAllDto.getInformation(), Information.class);
        informationService.save(information.setSurveyInformationId(surveyInformation.getSequenceNbr()));

        Commercial commercial = BeanDtoUtils.convert(surveyInfoAllDto.getCommercial(), Commercial.class);
        commercialService.save(commercial.setSurveyInformationId(surveyInformation.getSequenceNbr()));

        ExtendedInformation extendedInformation = BeanDtoUtils.convert(surveyInfoAllDto.getExtendedInformation(), ExtendedInformation.class);
        extendedInformationService.save(extendedInformation.setSurveyInformationId(surveyInformation.getSequenceNbr()));

        return surveyInfoAllDto;
    }

    public SurveyInfoAllDto querySurveyInfo(String surveyInformationId)   {

        SurveyInfoAllDto surveyInfoAllDto = new SurveyInfoAllDto();

        LambdaQueryWrapper<SurveyInformation> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SurveyInformation::getSequenceNbr, surveyInformationId);
        SurveyInformation surveyInformation = this.baseMapper.selectOne(queryWrapper);
        surveyInfoAllDto.setSurveyInformation(BeanDtoUtils.convert(surveyInformation, SurveyInformationDto.class));


        QueryWrapper<PeasantHousehold> peasantHouseholdQueryWrapper = new QueryWrapper<>();
        peasantHouseholdQueryWrapper.eq("survey_information_id", surveyInformationId);
        PeasantHousehold peasantHousehold = peasantHouseholdServiceImpl.getBaseMapper().selectOne(peasantHouseholdQueryWrapper);

        BeanUtils.copyProperties(peasantHousehold, surveyInfoAllDto.getSurveyInformation());

        surveyInfoAllDto.getSurveyInformation().setProjectAddressArr(JSON.parseArray(peasantHousehold.getProjectAddress(), Integer.class));
        if(!StringUtils.isEmpty(peasantHousehold.getPermanentAddress())){
            surveyInfoAllDto.getSurveyInformation().setPermanentAddressArr(JSON.parseArray(peasantHousehold.getPermanentAddress(), Integer.class));
        }else {
            surveyInfoAllDto.getSurveyInformation().setPermanentAddressArr(JSON.parseArray("[]", Integer.class));
            surveyInfoAllDto.getSurveyInformation().setIsPermanent(JSON.parseArray("[1]", String.class));
        }

//        if(StringUtils.isNotEmpty(peasantHousehold.getProjectAddress())) {
//            String[] pArr = peasantHousehold.getProjectAddress().split(",");
//            Integer[] convert = (Integer[]) ConvertUtils.convert(pArr, Integer.class);
//            surveyInfoAllDto.getSurveyInformation().setProjectAddressArr(convert);
//        }
//
//        if(StringUtils.isNotEmpty(peasantHousehold.getPermanentAddress())) {
//            String[] eArr =  peasantHousehold.getPermanentAddress().split(",");
//            Integer[] convert1 = (Integer[]) ConvertUtils.convert(eArr, Integer.class);
//            surveyInfoAllDto.getSurveyInformation().setPermanentAddressArr(convert1);
//        }

        QueryWrapper<SurveyDetails> surveyDetailsQueryWrapper = new QueryWrapper<>();
        surveyDetailsQueryWrapper.eq("survey_information_id", surveyInformationId);
        SurveyDetails surveyDetails = surveyDetailsService.getBaseMapper().selectOne(surveyDetailsQueryWrapper);

        surveyInfoAllDto.setSurveyDetails(BeanDtoUtils.convert(surveyDetails, SurveyDetailsDto.class));

        QueryWrapper<Information> informationQueryWrapper = new QueryWrapper<>();
        surveyDetailsQueryWrapper.eq("survey_information_id", surveyInformationId);
        Information information = informationService.getBaseMapper().selectOne(informationQueryWrapper);

        surveyInfoAllDto.setInformation(BeanDtoUtils.convert(information, InformationDto.class));

        QueryWrapper<Commercial> commercialQueryWrapper = new QueryWrapper<>();
        surveyDetailsQueryWrapper.eq("survey_information_id", surveyInformationId);
        Commercial commercial = commercialService.getBaseMapper().selectOne(commercialQueryWrapper);

        surveyInfoAllDto.setCommercial(BeanDtoUtils.convert(commercial, CommercialDto.class));

        QueryWrapper<ExtendedInformation> extendedInformationQueryWrapper = new QueryWrapper<>();
        surveyDetailsQueryWrapper.eq("survey_information_id", surveyInformationId);
        ExtendedInformation extendedInformation = extendedInformationService.getBaseMapper().selectOne(extendedInformationQueryWrapper);

        surveyInfoAllDto.setExtendedInformation(BeanDtoUtils.convert(extendedInformation, ExtendedInformationDto.class));

        return surveyInfoAllDto;
    }


    public JSONArray getRegionName(){
        JSONArray jsonArray = new JSONArray();
        if (redisUtils.hasKey(regionRedis)) {
            jsonArray= JSONArray.parseArray(redisUtils.get(regionRedis).toString());
        }else {
            Collection<RegionModel> regionChild = new ArrayList<>();
            RegionModel regionModel1 = new RegionModel();
            regionChild.add(regionModel1);
            FeignClientResult<Collection<RegionModel>> collectionFeignClientResult = Systemctl.regionClient.queryForTreeParent(610000L);
            Collection<RegionModel> result = collectionFeignClientResult.getResult();
            for (RegionModel regionModel : result) {
                for (RegionModel child : regionModel.getChildren()) {
                    for (RegionModel childChild : child.getChildren()) {
                        jsonArray.add(childChild);
                    }
                    child.setChildren(regionChild);
                    jsonArray.add(child);
                }
                regionModel.setChildren(regionChild);
                jsonArray.add(regionModel);
            }

            redisUtils.set(regionRedis,jsonArray);
        }
        return jsonArray;
    }
}