package com.yeejoin.amos.boot.module.jxiop.api.entity;

import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 户用光伏合同表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "household_pv_contact", autoResultMap = true)
public class HouseholdPvContact extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 户用光伏id
	 */
	@TableField("household_pv_id")
	private Long householdPvId;

	/**
	 * 备案证号
	 */
	@TableField(value = "number", updateStrategy = FieldStrategy.IGNORED)
	private String number;

	/**
	 * 合同期限
	 */
	@TableField(value = "period", typeHandler = FastjsonTypeHandler.class, updateStrategy = FieldStrategy.IGNORED)
	private List<String> period;

	/**
	 * 合同描述
	 */
	@TableField(value = "description", updateStrategy = FieldStrategy.IGNORED)
	private String description;

	/**
	 * 屋顶租赁及使用协议
	 */
	@TableField(value = "use_agreement", typeHandler = FastjsonTypeHandler.class)
	private List<CommonFile> useAgreement;

	/**
	 * 签约视频
	 */
	@TableField(value = "signing_video", typeHandler = FastjsonTypeHandler.class)
	private List<CommonFile> signingVideo;

	/**
	 * 备案证明
	 */
	@TableField(value = "filing_certificate", typeHandler = FastjsonTypeHandler.class)
	private List<CommonFile> filingCertificate;

	/**
	 * 创建时间
	 */
	@TableField("create_time")
	private Date createTime;


	/**
	 * 发电户号
	 */
	@TableField(value = "generation_number", updateStrategy = FieldStrategy.IGNORED)
	private String generationNumber;

	/**
	 * 购售电合同
	 */
	@TableField(value = "power_contract", typeHandler = FastjsonTypeHandler.class, updateStrategy = FieldStrategy.IGNORED)
	private List<CommonFile> powerContract;



}
