package com.yeejoin.amos.boot.module.tdc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.yeejoin.amos.boot.module.tdc.api.entity.CheckModel;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckReport;
import com.yeejoin.amos.boot.module.tdc.api.mapper.CheckReportMapper;
import com.yeejoin.amos.boot.module.tdc.api.service.CheckReportService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.List;

/**
 * @author DELL
 */
@Service
public class CheckReportImpl extends ServiceImpl<CheckReportMapper, CheckReport> implements CheckReportService {

    @Override
    public IPage<CheckReport> selectAll(int current,int size,String amosOrgCode) {
        Page page = new Page(current,size);

        if(ValidationUtil.isEmpty(amosOrgCode)){
            return this.page(page);
        }else{
            LambdaQueryWrapper<CheckReport> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(CheckReport::getAmosOrgCode, amosOrgCode);
            return this.page(page,wrapper);
        }

    }


}
