package com.yeejoin.amos.boot.module.tcm.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.module.tcm.api.dto.AlertCalledDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.AlertCalledFormDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.VoiceRecordFileDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.tcm.api.entity.VoiceRecordFile;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.AlertCalledServiceImpl;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.VoiceRecordFileServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.List;

/**
 * 通话记录附件
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "通话记录附件Api")
@RequestMapping(value = "/voice-record-file")
public class VoiceRecordFileController extends BaseController {

    @Autowired
    VoiceRecordFileServiceImpl voiceRecordFileServiceImpl;

	@Autowired
    AlertCalledServiceImpl iAlertCalledService;


	/**
	 * 根据警情id 查找通话记录信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据警情id 查找通话记录信息",   notes = "根据警情id 查找通话记录信息")
	@GetMapping(value = "/list/alert/{alertId}")
	public ResponseModel<List<VoiceRecordFileDto>> selectForListByAlertId(@PathVariable Long alertId) {
		LambdaQueryWrapper<VoiceRecordFile> queryWrapper = new LambdaQueryWrapper<VoiceRecordFile>();
		queryWrapper.eq(VoiceRecordFile::getAlertId, alertId).orderByDesc(VoiceRecordFile::getRecDate);
		List<VoiceRecordFile> list = voiceRecordFileServiceImpl.list(queryWrapper);
		List<VoiceRecordFileDto> dtoList = new ArrayList<VoiceRecordFileDto>(list.size());
		list.stream().forEach(voiceRecord -> {
			// 创建新的对象实例
			VoiceRecordFileDto target = new VoiceRecordFileDto();
			// 把原对象数据拷贝到新对象
			BeanUtils.copyProperties(voiceRecord, target);
			dtoList.add(target);
		});
		return ResponseHelper.buildResponse(dtoList);
	}

	/**
	 * 根据警情id 查找通话记录信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据id获取通话记录信息",   notes = "根据id获取通话记录信息")
	@GetMapping(value = "/{sequenceNbr}")
	public ResponseModel<VoiceRecordFileDto> getRecordById(@PathVariable Long sequenceNbr) {

		VoiceRecordFileDto record = voiceRecordFileServiceImpl.getRecordById(sequenceNbr);
		return ResponseHelper.buildResponse(record);
	}


	/**
	 * 新增-通话记录
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveRecord")
	@ApiOperation(httpMethod = "POST", value = "新增通话记录附件", notes = "新增通话记录附件")
	public ResponseModel<Boolean> saveRecord(@RequestBody VoiceRecordFileDto model) {
		if (ValidationUtil.isEmpty(model.getAlertId())
				|| ValidationUtil.isEmpty(model.getConnectId())){
			throw new BadRequest("参数校验失败.");
		}
		voiceRecordFileServiceImpl.publishRecord(model);
		return ResponseHelper.buildResponse(true);
	}



	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询通话记录", notes = "查询通话记录")
	@GetMapping("/selectRecord")
	public ResponseModel<Page<VoiceRecordFileDto>> queryVoiceCodeByPager(VoiceRecordFileDto model,
																			@RequestParam(value = "pageNum") int pageNum, @RequestParam(value = "pageSize") int pageSize, String sort ) {
		Page<VoiceRecordFileDto> page = new Page<VoiceRecordFileDto>();
		page.setCurrent(pageNum);
		page.setSize(pageSize);
		String sortParam = "";
		String sortRule = "";
		if(sort!=null) {  // 排序失效
			String[] date=  sort.split(",");
			if(date[1].equals("ascend")) {
				sortParam = RedisKey.humpToLine(date[0]);
				sortRule = "asc";
			}else {
				sortParam =RedisKey.humpToLine(date[0]);
				sortRule = "desc";
			}
		}else {
			sortParam = "tel_start_time";
			sortRule = "desc";
		}
		Page<VoiceRecordFileDto> pageBean = voiceRecordFileServiceImpl.queryRecordListByQueryDto(page,
				model.getTelStartTimeStr(),model.getTelEndTimeStr(),model.getFileType(),model.getTel(),
				model.getWorkNum(),sortParam,sortRule);
		Page<VoiceRecordFileDto> result = new Page<VoiceRecordFileDto>(pageNum,pageSize);
		long totle = pageBean.getTotal();
		result.setRecords(pageBean.getRecords());
		result.setTotal(totle);
		return ResponseHelper.buildResponse(result);
	}


}
