package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import java.math.BigDecimal;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 安全追溯-场内车辆
 * 
 * @author cpp
 * @date 2023-04-06 15:21:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("mid_equip_tech_param_vehicle")
public class MidEquipTechParamVehicle extends AbstractEquipBaseEntity {
	private static final long serialVersionUID = 1L;



	/**
  	 *  	 * $column.comments
     *      */

		@TableField(value ="\"INSTANCE_ID\"")
	private String instanceId;
	/**
  	 *  	 * $column.comments
     *      */

		@TableField(value ="\"STATUS\"")
	private String status;
	/**
  	 *  	 * 车架编号
     *      */

		@TableField(value ="\"FRAME_NO\"")
	private String frameNo;
	/**
  	 *  	 * 发动机（行走电机）编号
     *      */

		@TableField(value ="\"ENGINE_NO\"")
	private String engineNo;
	/**
  	 *  	 * 动力方式
     *      */

		@TableField(value ="\"POWER_MODE\"")
	private String powerMode;
	/**
  	 *  	 * 传动方式
     *      */

		@TableField(value ="\"TRANSMISSION_MODE\"")
	private String transmissionMode;
	/**
  	 *  	 * 车架结构
     *      */

		@TableField(value ="\"FRAME_STRUCTURE\"")
	private String frameStructure;
	/**
  	 *  	 * 驾驶方式
     *      */

		@TableField(value ="\"DRIVING_MODE\"")
	private String drivingMode;
	/**
  	 *  	 * 自重
     *      */

		@TableField(value ="\"WEIGHT\"")
	private BigDecimal weight;
	/**
  	 *  	 * 空载最大运行速度
     *      */

		@TableField(value ="\"CARRYING_IDLER_MAX_RUNNING_SPEED\"")
	private BigDecimal carryingIdlerMaxRunningSpeed;
	/**
  	 *  	 * 空载最大起升速度
     *      */

		@TableField(value ="\"MAX_LIFTING_SPEED\"")
	private BigDecimal maxLiftingSpeed;
	/**
  	 *  	 * 设备保护等级（防爆）
     *      */

		@TableField(value ="\"PROTECT_GRADE\"")
	private String protectGrade;
	/**
  	 *  	 * 气体/粉尘组别（防爆）
     *      */

		@TableField(value ="\"GAS_GROUP\"")
	private String gasGroup;
	/**
  	 *  	 * 温度组别（防爆）
     *      */

		@TableField(value ="\"TEMPERATURE_GROUP\"")
	private String temperatureGroup;
	/**
  	 *  	 * 额定起重量
     *      */

		@TableField(value ="\"LIFTING_CAPACITY\"")
	private BigDecimal liftingCapacity;
	/**
  	 *  	 * 系统电压
     *      */

		@TableField(value ="\"SYSTEM_VOLTAGE\"")
	private BigDecimal systemVoltage;
	/**
  	 *  	 * 载荷中心距
     *      */

		@TableField(value ="\"LOAD_CENTER_DISTANCE\"")
	private BigDecimal loadCenterDistance;
	/**
  	 *  	 * 发动机(电机)额定功率
     *      */

		@TableField(value ="\"ENGINE_POWER\"")
	private BigDecimal enginePower;
	/**
  	 *  	 * 最大速度（额载）
     *      */

		@TableField(value ="\"MAX_SPEED\"")
	private BigDecimal maxSpeed;
	/**
  	 *  	 * 防爆使用场所
     *      */

		@TableField(value ="\"EXPLOSIONPROOF_PLACE\"")
	private String explosionproofPlace;
	/**
  	 *  	 * 工作装置门架形式
     *      */

		@TableField(value ="\"GANTRY_FORM\"")
	private String gantryForm;
	/**
  	 *  	 * 工作装置空载最大起升高度
     *      */

		@TableField(value ="\"MAX_LIFTING_HEIGHT\"")
	private BigDecimal maxLiftingHeight;
	/**
  	 *  	 * 工作装置(全)自由起升高度
     *      */

		@TableField(value ="\"FREE_LIFTING_HEIGHT\"")
	private BigDecimal freeLiftingHeight;
	/**
  	 *  	 * 工作装置门架倾角（前）
     *      */

		@TableField(value ="\"PORTAL_ANGLE_FRONT\"")
	private BigDecimal portalAngleFront;
	/**
  	 *  	 * 工作装置门架倾角（后）
     *      */

		@TableField(value ="\"PORTAL_ANGLE_BEHIND\"")
	private BigDecimal portalAngleBehind;
	/**
  	 *  	 * 工作装置最大起升速度（空载）
     *      */

		@TableField(value ="\"MAX_LIFTING_SPEED1\"")
	private BigDecimal maxLiftingSpeed1;
	/**
  	 *  	 * 工作装置最大起升速度（额载）
     *      */

		@TableField(value ="\"MAX_LIFTING_SPEED2\"")
	private BigDecimal maxLiftingSpeed2;
	/**
  	 *  	 * 工作装置最大下降速度（空载）
     *      */

		@TableField(value ="\"MAX_DESCENT_SPEED1\"")
	private BigDecimal maxDescentSpeed1;
	/**
  	 *  	 * 工作装置最大下降速度（额载）
     *      */

		@TableField(value ="\"MAX_DESCENT_SPEED2\"")
	private BigDecimal maxDescentSpeed2;
	/**
  	 *  	 * 整车整备质量
     *      */

		@TableField(value ="\"VEHICLE_MASS\"")
	private BigDecimal vehicleMass;
	/**
  	 *  	 * 额定载客数
     *      */

		@TableField(value ="\"PASSENGERS_NUMBER\"")
	private Integer passengersNumber;
	/**
  	 *  	 * 最大运行速度
     *      */

		@TableField(value ="\"MAX_RUNNING_SPEED\"")
	private BigDecimal maxRunningSpeed;
	/**
  	 *  	 * 轴距
     *      */

		@TableField(value ="\"WHEEL_BASE\"")
	private BigDecimal wheelBase;
	/**
  	 *  	 * 轮距（前）
     *      */

		@TableField(value ="\"TRACK_WIDTH_FRONT\"")
	private BigDecimal trackWidthFront;
	/**
  	 *  	 * 轮距（后）
     *      */

		@TableField(value ="\"TRACK_WIDTH_BEHIND\"")
	private BigDecimal trackWidthBehind;
	/**
  	 *  	 * 观光列车车厢数
     *      */

		@TableField(value ="\"CARS_NUMBER\"")
	private Integer carsNumber;
	/**
  	 *  	 * 观光列车每节车厢座位数
     *      */

		@TableField(value ="\"SEAT_NUMBER\"")
	private Integer seatNumber;
	/**
  	 *  	 * 观光列车牵引车头座位数
     *      */

		@TableField(value ="\"TRACTOR_SEAT_NUMBER\"")
	private Integer tractorSeatNumber;
	/**
  	 *  	 * 最大行驶坡度
     *      */

		@TableField(value ="\"MAX_DRIVING_SLOPE\"")
	private BigDecimal maxDrivingSlope;
	/**
  	 *  	 * 制动距离
     *      */

		@TableField(value ="\"BRAKING_DISTANCE\"")
	private BigDecimal brakingDistance;
	/**
  	 *  	 * 全长
     *      */

		@TableField(value ="\"OVERALL_LENGTH\"")
	private BigDecimal overallLength;
	/**
  	 *  	 * 全宽
     *      */

		@TableField(value ="\"OVERALL_WIDTH\"")
	private BigDecimal overallWidth;
	/**
  	 *  	 * 全高
     *      */

		@TableField(value ="\"OVERALL_ALTITUDE\"")
	private BigDecimal overallAltitude;
	/**
  	 *  	 * 最小离地间隙
     *      */

		@TableField(value ="\"MIN_GROUND_CLEARANCE\"")
	private BigDecimal minGroundClearance;
	/**
  	 *  	 * 最小外侧转弯半径
     *      */

		@TableField(value ="\"MIN_TURNING_RADIUS\"")
	private BigDecimal minTurningRadius;
	/**
  	 *  	 * 主要零部件、安全保护和防护装置
     *      */

		@TableField(value ="\"MAIN_PARTS\"")
	private String mainParts;

	/**
  	 *  	 * 监管码
     *      */

		@TableField(value ="\"SUPERVISORY_CODE\"")
	private String supervisoryCode;


}
