package com.yeejoin.amos.boot.module.common.api.feign;

import java.util.List;
import java.util.Map;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;

@FeignClient(name = "${Knowledgebase.fegin.name:AMOS-API-KNOWLEDGEBASE}",path = "knowledgebase" ,configuration = {MultipartSupportConfig.class})
public interface KnowledgebaseFeignClient {
	
		 @RequestMapping(value = "/v1/tagvalue/getAll/tegartValue", method = RequestMethod.GET)
		 ResponseModel<Object>  getAllTegartValue(@RequestParam String value) ;
		 
		 @RequestMapping(value = "/v1/taginstance/find/{id}", method = RequestMethod.GET)
		 ResponseModel<Object> findById(@PathVariable("id") Long id);
		 
		 @RequestMapping(value = "/v1/doccontent/getSimpleDetail/{sequenceNbr}", method = RequestMethod.GET)
		 ResponseModel<Object> getSimpleDetail(@PathVariable(value = "sequenceNbr") String sequenceNbr);
		 
		 @RequestMapping(value = "/v1/taginstance/targetSeq/{id}", method = RequestMethod.GET)
		 ResponseModel<Object> queryListByTargetSeq(@PathVariable("id") Long id);
		 
		 @RequestMapping(value = "/v1/tagvalue/getOne/", method = RequestMethod.GET)
		 ResponseModel<Object> queryByInstance(@RequestParam Long id) ;
		 
		  @RequestMapping(value = "/v1/taginstance/getTarget/byName", method = RequestMethod.GET)
		 ResponseModel<Object> queryListByTagName(@RequestParam String name);
		 

		@RequestMapping(value = "/v1/doccontent/outer/{id}", method = RequestMethod.GET)
		ResponseModel<List<Map<String, Object>>> getDocById(@PathVariable Long id);

		@RequestMapping(value = "/v1/doccontent/doclibrary/page", method = RequestMethod.GET)
		ResponseModel<Object> getDocListByCategoryId(@RequestParam("filterByCollection") boolean filterByCollection,
				@RequestParam("directoryId") Long directoryId, @RequestParam("offset") int offset,
				@RequestParam("end") int end, @RequestParam("industryType") String industryType);

		/**
		 * 知识库知识随机数查询
		 * @param directories 分类
		 * @param total 随机数量
		 * @return List<Map<String, Object>>
		 */
		@GetMapping("/v1/doccontent/outer/random-list")
			ResponseModel<List<Map<String, Object>>> getRandomList(@RequestParam String directories, @RequestParam(required = false) Integer total);
}
