package com.yeejoin.amos.boot.module.jczs.flc.api.entity;

import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.TableName;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 气瓶标签信息
 *
 * @author duanwei
 * @date 2022-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_tags")
@ApiModel(value="TzCylinderTags对象", description="气瓶标签信息")
public class CylinderTags extends BaseEntity {

    private static final long serialVersionUID = 1L;





    @ApiModelProperty(value = "气瓶唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "二维码编号")
    @TableField("qrCode")
    private String qrCode;

    @ApiModelProperty(value = "电子标签编号")
    private String electronicLabelCode;



    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "0-新增   1-更新  2-删除")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

    @ApiModelProperty(value = "数据完整度")
    private Double integrity;

    @ApiModelProperty(value = "气瓶钢印标识")
    private String gasCylinderStamp;
}
