package com.yeejoin.amos.boot.module.jg.api.dto;

import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.module.ymt.api.dto.LicScheduleDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import springfox.documentation.spring.web.json.Json;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 使用登记表补证
 *
 * @author system_generator
 * @date 2025-03-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgCertificateReplenishDto", description = "使用登记表补证")
public class JgCertificateReplenishDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备种类编码")
    private String equListCode;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "设备类别编码")
    private String equCategoryCode;

    @ApiModelProperty(value = "设备类别")
    private String equCategory;

    @ApiModelProperty(value = "申请编号")
    private String applyNo;

    @ApiModelProperty(value = "申请日期")
    private Date applyDate;

    @ApiModelProperty(value = "申请状态")
    private String applyStatus;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitCode;

    @ApiModelProperty(value = "使用单位名称")
    private String useUnitName;

    @ApiModelProperty("补证日期")
    private Date reissueDate;

    @ApiModelProperty(value = "接收机构代码")
    private String receiveOrgCode;

    @ApiModelProperty(value = "接收机构名称")
    private String receiveOrgName;

    @ApiModelProperty(value = "使用登记编号")
    private String useRegistrationCode;

    @ApiModelProperty(value = "使用登记证补证申请表附件")
    private String applicationFormFile;

    @ApiModelProperty(value = "其他附件")
    private String otherAccessories;

    @ApiModelProperty(value = "补领原因 0 遗失；1 损毁")
    private String applicationReason;

    @ApiModelProperty(value = "遗失或者损毁时间")
    private Date lossDamageTime;

    @ApiModelProperty(value = "安全管理员名称")
    private String safetyManagerName;

    @ApiModelProperty(value = "安全管理员电话")
    private String safetyManagerPhone;

    @ApiModelProperty(value = "任务发起人id")
    private String promoter;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "下步执行角色/人id")
    private String nextExecuteIds;

    @ApiModelProperty(value = "下一节点可执行人逗号分割")
    private String nextExecuteUserIds;

    @ApiModelProperty(value = "下一步任务ID")
    private String nextTaskId;

    @ApiModelProperty(value = "受理完成日期")
    private Date acceptDate;

    @ApiModelProperty(value = "作废时间")
    private Date cancelDate;

    @ApiModelProperty(value = "作废人id")
    private String cancelUserId;

    @ApiModelProperty(value = "作废原因")
    private String cancelReason;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "创建人id ")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty("是否车用气瓶1是，0不是（特种气瓶使用）")
    private String whetherVehicleCylinder;
    private String dataType;
    private List<Map<String, Object>> equLists;

    @ApiModelProperty("使用登记证补证申请表URL")
    private String applicationFormFileUrl;

    @ApiModelProperty("设备使用地址")
    private String equUseAddress;

}
