package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgVehicleInformationDto;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgVehicleInformation;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.VehicleInformationVo;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 *  Mapper 接口
 *
 * @author system_generator
 * @date 2024-03-18
 */
public interface JgVehicleInformationMapper extends BaseMapper<JgVehicleInformation> {

    @MapKey("roleIds")
    Page<Map<String, Object>> getListPage(@Param("page")Page<Map<String, Object>> page,
                                          @Param("sort") SortVo sortMap,
                                          @Param("dto") JgVehicleInformationDto dto ,
                                          @Param("roleIds") List<String> roleIds,
                                          @Param("client") String client);

    List<VehicleInformationVo> queryVehicleInformationInIds(@Param("ids") List<String> ids);

    @MapKey("sequenceNbr")
    JgVehicleInformationDto queryBySequenceNbr(@Param("sequenceNbr") Long sequenceNbr);

    @MapKey("id")
    List<Map<String, Object>> selectEquipList(@Param("id")Long id);

    @MapKey("records")
    List<Map<String, Object>> queryForUnitVesselEquipment(@Param("sequenceNbr") Long sequenceNbr, @Param("records")List<String> records);

    Long countVesselCylinderIsUsedNumber(@Param("vehicleId") Long vehicleId, @Param("records") List<String> records);

    @Select("select name from tz_equipment_category where code=#{code}")
    String getEquCategoryNameByCode(String code);

    List<CompanyEquipCountDto> queryForFlowingEquipList();

    Integer countUseTimesForInvalid(@Param("code") Object code);

    List<JgVehicleInformation> getListOfPass();

    List<Map<String, Object>> getVehicleInfoOfPassWithEquId();

    List<ReminderItemDto> queryUnitVehiclesForReminderList(@Param("records") List<String> records);
}
