package com.yeejoin.amos.boot.module.tzs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 单位注册许可信息表
 *
 * @author system_generator
 * @date 2022-08-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="BaseUnitLicenceDto", description="单位注册许可信息表")
public class BaseUnitLicenceDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "单位编码")
    private String unitCode;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "许可地址")
    private String licAddress;

    @ApiModelProperty(value = "证书类型")
    private String certType;

    @ApiModelProperty(value = "证书编号")
    private String certNo;

    @ApiModelProperty(value = "有效期至")
    private Date expiryDate;

    @ApiModelProperty(value = "发证日期")
    private Date issueDate;

    @ApiModelProperty(value = "变更日期")
    private Date changeDate;

    @ApiModelProperty(value = "许可评审方式")
    private String applyType;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "许可项目/检验类型/设备品种编码")
    private String itemCode;

    @ApiModelProperty(value = "许可项目/检验类型/设备品种")
    private String itemCodeName;

    @ApiModelProperty(value = "许可子项目/检验项目/充装介质类别code")
    private String subItemCode;

    @ApiModelProperty(value = "许可子项目/检验项目/充装介质类别")
    private String subItemName;

    @ApiModelProperty(value = "许可参数/充装介质名称")
    private String parameter;

    @ApiModelProperty(value = "固定检验地址")
    private String itemAddress;

}
